/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.ParameterVariables;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import java.io.Serializable;
import java.util.List;

public abstract class EF_Distribution
implements Serializable {
    private static final long serialVersionUID = -3436599636425587512L;
    protected NaturalParameters naturalParameters;
    protected MomentParameters momentParameters;

    public NaturalParameters getNaturalParameters() {
        return this.naturalParameters;
    }

    public MomentParameters getMomentParameters() {
        return this.momentParameters;
    }

    public void setNaturalParameters(NaturalParameters parameters) {
        this.naturalParameters = parameters;
        this.updateMomentFromNaturalParameters();
    }

    public void setMomentParameters(SufficientStatistics parameters) {
        this.momentParameters = (MomentParameters)((Object)parameters);
        this.updateNaturalFromMomentParameters();
    }

    public void setMomentParameters(MomentParameters parameters) {
        this.momentParameters = parameters;
        this.updateNaturalFromMomentParameters();
    }

    public abstract void updateNaturalFromMomentParameters();

    public abstract void updateMomentFromNaturalParameters();

    public abstract SufficientStatistics getSufficientStatistics(Assignment var1);

    public abstract int sizeOfSufficientStatistics();

    public abstract double computeLogBaseMeasure(Assignment var1);

    public abstract double computeLogNormalizer();

    public double computeLogProbabilityOf(Assignment assignment) {
        return this.naturalParameters.dotProduct(this.getSufficientStatistics(assignment)) + this.computeLogBaseMeasure(assignment) - this.computeLogNormalizer();
    }

    public abstract Vector createZeroVector();

    public MomentParameters createZeroMomentParameters() {
        return (MomentParameters)this.createZeroVector();
    }

    public SufficientStatistics createZeroSufficientStatistics() {
        return (SufficientStatistics)this.createZeroVector();
    }

    public abstract SufficientStatistics createInitSufficientStatistics();

    public NaturalParameters createZeroNaturalParameters() {
        return (NaturalParameters)this.createZeroVector();
    }

    protected List<EF_ConditionalDistribution> toExtendedLearningDistribution(ParameterVariables variables, String nameSuffix) {
        throw new UnsupportedOperationException("Not convertible to Learning distribution");
    }

    public List<EF_ConditionalDistribution> toExtendedLearningDistribution(ParameterVariables variables) {
        return this.toExtendedLearningDistribution(variables, "");
    }
}

