library(quanteda)
context("plot functions")

# skip("Skipping plots")
skip_on_ci()
skip_on_cran()
skip_if_not_installed("vdiffr")
skip_if_not_installed("FNN")


mini_corpus <- head(data_corpus_inaugural, n = 10)
mini_corpus <- split_segments(mini_corpus)
tok <- tokens(mini_corpus, remove_punct = TRUE)
tok <- tokens_tolower(tok)
tok <- tokens_remove(tok, stopwords("en"))
dtm <- dfm(tok)
dtm <- dfm_trim(dtm, min_termfreq = 3)

res1 <- rainette(dtm, k = 6, min_segment_size = 5, min_split_members = 3)
res2 <- rainette(dtm, k = 6, min_segment_size = 10, min_split_members = 3)
res12 <- rainette2(res1, res2, max_k = 6)

plot1 <- rainette_plot(res1, dtm, k = 6)
plot2 <- rainette_plot(res1, dtm, k = 5, free_scales = TRUE)
plot3 <- rainette_plot(res1, dtm, k = 5, measure = "lr")
plot3b <- rainette_plot(res1, dtm, k = 5, measure = "frequency")
plot3c <- rainette_plot(res1, dtm, k = 5, measure = "docprop")
plot4 <- rainette_plot(res1, dtm, k = 3, show_negative = FALSE)
plot5 <- rainette_plot(res1, dtm, k = 4, n_terms = 20, text_size = 9)

vdiffr::expect_doppelganger("Base rainette_plot", plot1)
vdiffr::expect_doppelganger("Base rainette_plot with free_scales", plot2)
vdiffr::expect_doppelganger("Base rainette_plot measure='lr'", plot3)
vdiffr::expect_doppelganger("Base rainette_plot measure='frequency'", plot3b)
vdiffr::expect_doppelganger("Base rainette_plot measure='docprop'", plot3c)
vdiffr::expect_doppelganger("Base rainette_plot with k and without negative", plot4)
vdiffr::expect_doppelganger("Base rainette_plot with k, n_terms and font_size", plot5)

plot8 <- rainette2_plot(res12, dtm, k = 5)
plot8b <- rainette2_plot(res12, dtm, k = 6)
plot9 <- rainette2_plot(res12, dtm, k = 4, free_scales = TRUE)
plot10 <- rainette2_plot(res12, dtm, k = 4, measure = "lr")
plot10b <- rainette2_plot(res12, dtm, k = 4, measure = "frequency")
plot10c <- rainette2_plot(res12, dtm, k = 4, measure = "docprop")
plot11 <- rainette2_plot(res12, dtm, k = 3, show_negative = FALSE)
plot12 <- rainette2_plot(res12, dtm, k = 4, n_terms = 20, text_size = 9)
plot13 <- rainette2_plot(res12, dtm, k = 4, complete_groups = TRUE)

vdiffr::expect_doppelganger("Base rainette2_plot", plot8)
vdiffr::expect_doppelganger("Base rainette2_plot with k > 5", plot8b)
vdiffr::expect_doppelganger("Base rainette2_plot with free_scales", plot9)
vdiffr::expect_doppelganger("Base rainette2_plot measure='lr'", plot10)
vdiffr::expect_doppelganger("Base rainette2_plot measure='frequency'", plot10b)
vdiffr::expect_doppelganger("Base rainette2_plot measure='docprop'", plot10c)
vdiffr::expect_doppelganger("Base rainette2_plot with k and without negative", plot11)
vdiffr::expect_doppelganger("Base rainette2_plot with k, n_terms and font_size", plot12)
vdiffr::expect_doppelganger("Base rainette2_plot with complete_groups", plot13)
