% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_getXYcoords.R
\name{sdm_getXYcoords}
\alias{sdm_getXYcoords}
\title{Computes the X and Y Coordinates of the Pixels of a Raster Map}
\usage{
sdm_getXYcoords(w)
}
\arguments{
\item{w}{an object of class \code{asc}.}
}
\value{
Returns a list with two components: \item{x}{the x coordinates of
the columns of pixels of the map} \item{y}{the y coordinates of the rows of
pixels of the map}
}
\description{
Computes the X and Y Coordinates of the Pixels of a Raster Map
}
\details{
\code{sdm_getXYcoords} is an adaptation of \code{getXYcoords} from
SDMTools; computes the geographical coordinates of the rows and
columns of pixels of a raster map of class \code{asc}.
}
\examples{
\dontrun{
tasc = sdm_as_asc(matrix(rep(x=1:10, times=1000),nr=100)); print(tasc)
sdm_getXYcoords(tasc)
}
}
\author{
Gopi Goteti
}
