% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\docType{methods}
\name{image.radiomics}
\alias{image,glcm-method}
\alias{image,glrlm-method}
\alias{image,glszm-method}
\alias{image,mglszm-method}
\alias{image.radiomics}
\title{Texture Matrix Visualization}
\usage{
\S4method{image}{glcm}(x, xlab = "Grey Level", ylab = "Grey Level",
  col = colscale(length(unique(c(x@.Data)))))

\S4method{image}{glrlm}(x, xlab = "Grey Level", ylab = "Run Length",
  col = colscale(length(unique(c(x@.Data)))))

\S4method{image}{glszm}(x, xlab = "Grey Level", ylab = "Zone Size",
  col = colscale(length(unique(c(x@.Data)))))

\S4method{image}{mglszm}(x, xlab = "Grey Level", ylab = "Zone Size",
  col = colscale(length(unique(c(x@.Data)))))
}
\arguments{
\item{x}{Matrix of class "glcm", "glrlm", "glszm" or "mglszm"}

\item{xlab}{The label for the x-axis}

\item{ylab}{The label for the y-axis}

\item{col}{Use viridis scale if available}
}
\description{
Texture Matrix Visualization

GLCM image

GLRLM image

GLSZM image

MGLSZM image
}
\examples{
\dontrun{
image(psf)
image(glszm(psf))
}
}

