% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/merge.R
\name{mergedata}
\alias{mergedata}
\title{Merge datasets using dplyr's join functions}
\usage{
mergedata(dataset, dataset2, merge_vars = "", merge_type = "inner_join",
  merge_name = paste0("merged_", dataset))
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{dataset2}{Dataset name (string) to merge with `dataset`. This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{merge_vars}{Variables used to merge/join `dataset` and `dataset2`}

\item{merge_type}{The main join types from the dplyr package are provided. `inner_join` returns all rows from x with matching values in y, and all columns from x and y. If there are multiple matches between x and y, all match combinations are returned. `left_join` returns all rows from x, and all columns from x and y. If there are multiple matches between x and y, all match combinations are returned. `semi_join` returns all rows from x with matching values in y, keeping just columns from x. A semi join differs from an inner join because an inner join will return one row of x for each matching row of y, whereas a semi join will never duplicate rows of x. `anti_join` returns all rows from x without matching values in y, keeping only columns from x}

\item{merge_name}{Name for the merged dataset}
}
\value{
If (reactive) list `r_data` exists the merged dataset added as `merge_name`. Else the merged dataset will be returned as `merge_name`
}
\description{
Merge datasets using dplyr's join functions
}
\details{
See \url{http://mostly-harmless.github.io/radiant/base/merge.html} for an example in Radiant
}
\examples{
mergedata("titanic","titanic_pred",c("pclass","sex","age")) \%>\% head
}

