% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_tabs.R
\name{plot.cross_tabs}
\alias{plot.cross_tabs}
\title{Plot method for the cross_tabs function}
\usage{
\method{plot}{cross_tabs}(x, check = "", shiny = FALSE, custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{cross_tabs}}}

\item{check}{Show plots for variables var1 and var2. "observed" for the observed frequencies table, "expected" for the expected frequencies table (i.e., frequencies that would be expected if the null hypothesis holds), "chi_sq" for the contribution to the overall chi-squared statistic for each cell (i.e., (o - e)^2 / e), "dev_std" for the standardized differences between the observed and expected frequencies (i.e., (o - e) / sqrt(e)), and "row_perc", "col_perc", and "perc" for row, column, and table percentages respectively}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{https://ggplot2.tidyverse.org/} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the cross_tabs function
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/cross_tabs.html} for an example in Radiant
}
\examples{
result <- cross_tabs(newspaper, "Income", "Newspaper")
plot(result, check = c("observed","expected","chi_sq"))

}
\seealso{
\code{\link{cross_tabs}} to calculate results

\code{\link{summary.cross_tabs}} to summarize results
}
