## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ------------------------------------------------------------------------
library(reticulate)

torch      <- import("torch")
Variable   <- import("torch.autograd")$Variable
np         <- import("numpy")
optim      <- import("torch.optim") 
py         <- import_builtins()

## ------------------------------------------------------------------------
x = torch$rand(20L, 50L, 100L)
x_size <- x$size()
x_size
class(x_size)

## ------------------------------------------------------------------------
it <- iterate(py$enumerate(x_size))  # [[3]][[2]]
# for (i in it) print(i)
sapply(it, identity)

## ------------------------------------------------------------------------
y <- torch$Size(c(1L, 2L, 3L, 4L))
class(y)
y$index
it <- iterate(py$enumerate(y))
sapply(it, identity)

## ------------------------------------------------------------------------
p <- torch$Tensor(torch$Size(c(256L, 3L, 9L, 9L, 2L)))
class(p)
it <- iterate(py$enumerate(p$size()))
class(sapply(it, `[`))
# "matrix"
m <- sapply(it, `[`)
v <- m[2, ]
class(unlist(v))
unlist(v)
p

