/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.text.ParseException;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Copy
extends SvnCommand {
    private File srcPath = null;
    private File destPath = null;
    private SVNUrl srcUrl = null;
    private SVNUrl destUrl = null;
    private SVNRevision revision = SVNRevision.HEAD;
    private String message = null;
    private ISVNClientAdapter svnClient;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Copy");
        try {
            if (this.srcPath != null) {
                if (this.destPath != null) {
                    iSVNClientAdapter.copy(this.srcPath, this.destPath);
                } else {
                    iSVNClientAdapter.copy(this.srcPath, this.destUrl, this.message);
                }
            } else if (this.destPath != null) {
                iSVNClientAdapter.copy(this.srcUrl, this.destPath, this.revision);
            } else {
                iSVNClientAdapter.copy(this.srcUrl, this.destUrl, this.message, this.revision);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Can't copy", (Throwable)sVNClientException);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.srcPath == null && this.srcUrl == null || this.srcPath != null && this.srcUrl != null) {
            throw new BuildException("srcPath attribute or srcUrl attribute must be set");
        }
        if (this.destPath == null && this.destUrl == null || this.destPath != null && this.destUrl != null) {
            throw new BuildException("destPath attribute or destUrl attribute must be set");
        }
        if (this.destUrl != null && this.message == null) {
            throw new BuildException("message attribute needed when destUrl is set");
        }
        if (this.destUrl == null && this.message != null) {
            throw new BuildException("message attribute cannot be used when destUrl is not set");
        }
        if (this.revision == null) {
            throw new BuildException("Invalid revision. Revision should be a number, a date in MM/DD/YYYY HH:MM AM_PM format or HEAD, BASE, COMMITED or PREV");
        }
    }

    public void setSrcPath(File file) {
        this.srcPath = file;
    }

    public void setDestPath(File file) {
        this.destPath = file;
    }

    public void setSrcUrl(SVNUrl sVNUrl) {
        this.srcUrl = sVNUrl;
    }

    public void setDestUrl(SVNUrl sVNUrl) {
        this.destUrl = sVNUrl;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setRevision(String string) {
        try {
            this.revision = SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            this.revision = null;
        }
    }
}

