/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import org.python.expose.generate.Exposer;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.PyTypes;
import org.python.objectweb.asm.Type;

public abstract class MethodExposer
extends Exposer {
    protected String[] defaults;
    protected final String[] asNames;
    protected final String prefix;
    protected final String typeName;
    protected final Type[] args;
    protected final String methodName;
    protected final Type onType;
    protected final Type returnType;
    protected final String doc;

    public MethodExposer(Type onType, String methodName, Type[] args, Type returnType, String typeName, String[] asNames, String[] defaults, Class superClass, String doc) {
        super(superClass, onType.getClassName() + "$" + methodName + "_exposer", new Type[0]);
        this.onType = onType;
        this.methodName = methodName;
        this.args = args;
        this.typeName = typeName;
        this.doc = doc;
        String prefix = typeName;
        int lastDot = prefix.lastIndexOf(46);
        if (lastDot != -1) {
            prefix = prefix.substring(lastDot + 1);
        }
        this.prefix = prefix;
        this.asNames = asNames;
        this.returnType = returnType;
        this.defaults = defaults;
        for (String name : this.getNames()) {
            if (!name.equals("__new__")) continue;
            this.throwInvalid("@ExposedNew must be used to create __new__, not @ExposedMethod");
        }
    }

    protected void throwInvalid(String msg) {
        throw new InvalidExposingException(msg + "[method=" + this.onType.getClassName() + "." + this.methodName + "]");
    }

    public String[] getNames() {
        if (this.asNames.length == 0) {
            String name = this.methodName;
            if (name.startsWith(this.prefix + "_")) {
                name = this.methodName.substring((this.prefix + "_").length());
            }
            return new String[]{name};
        }
        return this.asNames;
    }

    protected void generate() {
        this.generateNamedConstructor();
        this.generateFullConstructor();
        this.generateBind();
        if (MethodExposer.isWide(this.args)) {
            this.generateWideCall();
        } else {
            for (int i = 0; i < this.defaults.length + 1; ++i) {
                this.generateCall(i);
            }
        }
    }

    private void generateFullConstructor() {
        this.startConstructor(PYTYPE, PYOBJ, BUILTIN_INFO);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, 2);
        this.mv.visitVarInsn(25, 3);
        this.superConstructor(PYTYPE, PYOBJ, BUILTIN_INFO);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitLdcInsn(this.doc);
        this.mv.visitFieldInsn(181, BUILTIN_FUNCTION.getInternalName(), "doc", STRING.getDescriptor());
        this.endConstructor();
    }

    private void generateNamedConstructor() {
        this.startConstructor(STRING);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        if (MethodExposer.isWide(this.args)) {
            this.superConstructor(STRING);
        } else {
            this.mv.visitLdcInsn(this.args.length + 1 - this.defaults.length);
            this.mv.visitLdcInsn(this.args.length + 1);
            this.superConstructor(STRING, INT, INT);
        }
        this.mv.visitVarInsn(25, 0);
        this.mv.visitLdcInsn(this.doc);
        this.mv.visitFieldInsn(181, BUILTIN_FUNCTION.getInternalName(), "doc", STRING.getDescriptor());
        this.endConstructor();
    }

    private void generateBind() {
        this.startMethod("bind", BUILTIN_FUNCTION, PYOBJ);
        this.instantiate(this.thisType, new Exposer.Instantiator(new Type[]{PYTYPE, PYOBJ, BUILTIN_INFO}){

            public void pushArgs() {
                MethodExposer.this.mv.visitVarInsn(25, 0);
                MethodExposer.this.call(MethodExposer.this.thisType, "getType", PyTypes.PYTYPE, new Type[0]);
                MethodExposer.this.mv.visitVarInsn(25, 1);
                MethodExposer.this.get("info", PyTypes.BUILTIN_INFO);
            }
        });
        this.endMethod(176);
    }

    private void generateWideCall() {
        this.startMethod("__call__", PYOBJ, APYOBJ, ASTRING);
        this.get("self", PYOBJ);
        this.checkSelf();
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, 2);
        this.makeCall();
        this.toPy(this.returnType);
        this.endMethod(176);
    }

    private boolean hasDefault(int argIndex) {
        return this.defaults.length - this.args.length + argIndex >= 0;
    }

    private String getDefault(int argIndex) {
        return this.defaults[this.defaults.length - this.args.length + argIndex];
    }

    private void generateCall(int numDefaults) {
        int i;
        int usedLocals = 1;
        Type[] callArgs = new Type[this.args.length - numDefaults];
        for (i = 0; i < callArgs.length; ++i) {
            callArgs[i] = PYOBJ;
        }
        this.startMethod("__call__", PYOBJ, callArgs);
        this.get("self", PYOBJ);
        this.checkSelf();
        for (i = 0; i < callArgs.length; ++i) {
            this.mv.visitVarInsn(25, usedLocals++);
            if (PRIMITIVES.containsKey(this.args[i])) {
                this.callStatic(PY, "py2" + this.args[i].getClassName(), this.args[i], PYOBJ);
                continue;
            }
            if (!this.args[i].equals(STRING)) continue;
            if (this.hasDefault(i) && this.getDefault(i).equals("null")) {
                this.call(PYOBJ, "asStringOrNull", STRING, new Type[0]);
                continue;
            }
            this.call(PYOBJ, "asString", STRING, new Type[0]);
        }
        for (i = callArgs.length; i < this.args.length; ++i) {
            this.pushDefault(this.getDefault(i), this.args[i]);
        }
        this.makeCall();
        this.toPy(this.returnType);
        this.endMethod(176);
    }

    protected abstract void checkSelf();

    protected abstract void makeCall();

    private void pushDefault(String def, Type arg) {
        if (def.equals("Py.None")) {
            this.getStatic(PY, "None", PYOBJ);
        } else if (def.equals("null")) {
            this.mv.visitInsn(1);
        } else if (arg.equals(Type.LONG_TYPE)) {
            this.mv.visitLdcInsn(new Long(def));
        } else if (arg.equals(INT)) {
            this.mv.visitLdcInsn(new Integer(def));
        } else if (arg.equals(BYTE)) {
            this.mv.visitLdcInsn(new Byte(def).intValue());
        } else if (arg.equals(SHORT)) {
            this.mv.visitLdcInsn(new Short(def).intValue());
        } else if (arg.equals(CHAR)) {
            if (def.length() != 1) {
                this.throwInvalid("A default for a char argument must be one character in length");
            }
            this.mv.visitLdcInsn(new Character(def.charAt(0)).charValue());
        } else if (arg.equals(BOOLEAN)) {
            this.mv.visitLdcInsn(Boolean.valueOf(def) != false ? 1 : 0);
        } else if (arg.equals(Type.FLOAT_TYPE)) {
            this.mv.visitLdcInsn(new Float(def));
        } else if (arg.equals(Type.DOUBLE_TYPE)) {
            this.mv.visitLdcInsn(new Double(def));
        }
    }

    protected static boolean isWide(Type[] args) {
        return args.length == 2 && args[0].equals(APYOBJ) && args[1].equals(ASTRING);
    }
}

