% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic.R
\name{variogram.intrinsic.spde}
\alias{variogram.intrinsic.spde}
\title{Variogram of intrinsic SPDE model}
\usage{
variogram.intrinsic.spde(
  s0 = NULL,
  s = NULL,
  kappa = NULL,
  alpha = NULL,
  beta = NULL,
  tau = 1,
  L = NULL,
  N = 100,
  d = NULL
)
}
\arguments{
\item{s0}{The location where the variogram should be evaluated, either
a double for 1d or a vector for 2d}

\item{s}{A vector (in 1d) or matrix (in 2d) with all locations where the
variogram is computed}

\item{kappa}{Range parameter.}

\item{alpha}{Smoothness parameter.}

\item{beta}{Smoothness parameter.}

\item{tau}{Precision parameter.}

\item{L}{The side length of the square domain.}

\item{N}{The number of terms in the Karhunen-Loeve expansion.}

\item{d}{The dimension (1 or 2).}
}
\description{
Variogram \eqn{\gamma(s_0,s)}{\gamma(s_0,s)} of intrinsic SPDE
model
\deqn{(-\Delta)^{\beta/2}(\kappa^2-\Delta)^{\alpha/2} (\tau u) = \mathcal{W}}{(-\Delta)^{\beta/2}(\kappa^2-\Delta)^{\alpha/2} (\tau u) = \mathcal{W}}
with Neumann boundary conditions and a mean-zero constraint on a
square \eqn{[0,L]^d}{[0,L]^d} for \eqn{d=1}{d=1} or \eqn{d=2}{d=2}.
}
\details{
The variogram is computed based on a Karhunen-Loeve expansion of the
covariance function.
}
\examples{
if (requireNamespace("RSpectra", quietly = TRUE)) {
  x <- seq(from = 0, to = 10, length.out = 201)
  beta <- 1
  alpha <- 1
  kappa <- 1
  op <- intrinsic.matern.operators(
    kappa = kappa, tau = 1, alpha = alpha,
    beta = beta, loc_mesh = x, d = 1
  )
  # Compute and plot the variogram of the model
  Sigma <- op$A[,-1] \%*\% solve(op$Q[-1,-1], t(op$A[,-1]))
  One <- rep(1, times = ncol(Sigma))
  D <- diag(Sigma)
  Gamma <- 0.5 * (One \%*\% t(D) + D \%*\% t(One) - 2 * Sigma)
  k <- 100
  plot(x, Gamma[k, ], type = "l")
  lines(x,
    variogram.intrinsic.spde(x[k], x, kappa, alpha, beta, L = 10, d = 1),
    col = 2, lty = 2
  )
}
}
\seealso{
\code{\link[=intrinsic.matern.operators]{intrinsic.matern.operators()}}
}
