% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{get.initial.values.rSPDE}
\alias{get.initial.values.rSPDE}
\title{Initial values for log-likelihood optimization in rSPDE models
with a latent stationary Gaussian Matern model}
\usage{
get.initial.values.rSPDE(
  mesh = NULL,
  mesh.range = NULL,
  graph.obj = NULL,
  n.spde = 1,
  dim = NULL,
  B.tau = NULL,
  B.kappa = NULL,
  B.sigma = NULL,
  B.range = NULL,
  nu = NULL,
  parameterization = c("matern", "spde"),
  include.nu = TRUE,
  log.scale = TRUE,
  nu.upper.bound = NULL
)
}
\arguments{
\item{mesh}{An in INLA mesh}

\item{mesh.range}{The range of the mesh.}

\item{graph.obj}{A \code{metric_graph} object. To be used in case both \code{mesh} and \code{mesh.range} are \code{NULL}.}

\item{n.spde}{The number of basis functions in the mesh model.}

\item{dim}{The dimension of the domain.}

\item{B.tau}{Matrix with specification of log-linear model for \eqn{\tau}. Will be used if \code{parameterization = 'spde'}.}

\item{B.kappa}{Matrix with specification of log-linear model for \eqn{\kappa}. Will be used if \code{parameterization = 'spde'}.}

\item{B.sigma}{Matrix with specification of log-linear model for \eqn{\sigma}. Will be used if \code{parameterization = 'matern'}.}

\item{B.range}{Matrix with specification of log-linear model for \eqn{\rho}, which is a range-like parameter (it is exactly the range parameter in the stationary case). Will be used if \code{parameterization = 'matern'}.}

\item{nu}{The smoothness parameter.}

\item{parameterization}{Which parameterization to use? \code{matern} uses range, std. deviation and nu (smoothness). \code{spde} uses kappa, tau and nu (smoothness). The default is \code{matern}.}

\item{include.nu}{Should we also provide an initial guess for nu?}

\item{log.scale}{Should the results be provided in log scale?}

\item{nu.upper.bound}{Should an upper bound for nu be considered?}
}
\value{
A vector of the form (theta_1,theta_2,theta_3) or where
theta_1 is the initial guess for tau, theta_2 is the initial guess for kappa
and theta_3 is the initial guess for nu.
}
\description{
Auxiliar function to obtain domain-based initial values for
log-likelihood optimization in rSPDE models
with a latent stationary Gaussian Matern model
}
