% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot_front}
\alias{plot_front}
\title{Pareto Front Plot}
\usage{
plot_front(df, pref, ...)
}
\arguments{
\item{df}{The dataframe for which the Pareto front is plotted. This may be already a maxima set w.r.t. the preference \code{pref},
but anyway the maxima set is recalculated via \code{psel(df, pref)}.}

\item{pref}{The preference representing the Skyline goals. This must be a pareto (\code{p1 * p2}) or intersection (\code{p1 | p2}) composition of
two \code{\link{low}} or \code{\link{high}} preferences.}

\item{...}{Additional graphic parameters which are passed to the \code{\link{segments}} function (internally used to plot the front).}
}
\description{
Connects the points of a Pareto front (also known as Pareto frontier) and hence visualizes the dominance region of a Skyline.
}
\details{
\code{plot_front} assumes that there is an existing plot, where the value of the first preference was plotted as x-coordinate
and the value of the second preference as y-coordinate.
}
\examples{
# Plots Pareto fronts for the hp/mpg values of mtcars
show_front <- function(pref) {
  plot(mtcars$hp, mtcars$mpg)
  sky <- psel(mtcars, pref)
  plot_front(mtcars, pref, col = rgb(0,0,1))
  points(sky$hp, sky$mpg, lwd = 3)
}

# Do this for all four combinations of pareto compositions
show_front(low(hp)  * low(mpg))
show_front(low(hp)  * high(mpg))
show_front(high(hp) * low(mpg))
show_front(high(hp) * high(mpg))

# Compare this to the front of a intersection preference
show_front(high(hp) | high(mpg))
}

