% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{tg.findLabels}
\alias{tg.findLabels}
\title{tg.findLabels}
\usage{
tg.findLabels(tg, tierInd, labelVector, returnTime = FALSE)
}
\arguments{
\item{tg}{TextGrid object}

\item{tierInd}{tier index or "name"}

\item{labelVector}{character string (one label) or vector of character strings (consecutive sequence of labels) to be found}

\item{returnTime}{If TRUE, return vectors of begin (t1) and end time (t2) for each found group of sequence of labels instead of indices (when FALSE = default).}
}
\value{
If returnTime == FALSE, returns list of all occurrences, each member of the list is one occurence and contains vector of label indices, if returnTime == TRUE, returns list witch vectors t1 (begin) and t2 (end) for each found group of sequence of labels.
}
\description{
Find label or consecutive sequence of labels and returns their indices.
}
\examples{
tg <- tg.sample()
i <- tg.findLabels(tg, "phoneme", "n")
i
length(i)
i[[1]]
i[[2]]
tg$phoneme$label[unlist(i)]

i <- tg.findLabels(tg, "phone", c("?", "a"))
i
length(i)
tg$phone$label[i[[1]]]
tg$phone$label[i[[2]]]
tg$phone$label[unlist(i)]

t <- tg.findLabels(tg, "phone", c("?", "a"), returnTime = TRUE)
t
t$t2[1] - t$t1[1]   # duration of the first result
t$t2[2] - t$t1[2]   # duration of the second result

i <- tg.findLabels(tg.sample(), "word", c("ti", "reknu", "co"))
i
length(i)
length(i[[1]])
i[[1]]
i[[1]][3]
tg$word$label[i[[1]]]

t <- tg.findLabels(tg.sample(), "word", c("ti", "reknu", "co"), returnTime = TRUE)
pt <- pt.sample()
tStart <- t$t1[1]
tEnd <- t$t2[1]
\dontrun{
pt.plot(pt.cut(pt, tStart, tEnd))
}
}
\seealso{
\code{\link{tg.countLabels}}, \code{\link{tg.getLabel}}, \code{\link{tg.duplicateTierMergeSegments}}
}
