% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtr.plot.temp.R
\name{wtr.plot.temp}
\alias{wtr.plot.temp}
\title{Creates a time series plot of the thermocline and top and 
bottom of the metalimnion}
\usage{
wtr.plot.temp(wtr, ...)
}
\arguments{
\item{wtr}{Data frame of water temperature loaded with \code{\link{load.ts}}.}

\item{...}{Additional paramters supplied to \code{\link{ts.meta.depths}} and \code{\link{ts.thermo.depth}}}
}
\description{
A line based plot of calculated depths of the thermocline, and 
top and bottom of the metalimnion from a temperature profile time series.
}
\examples{

wtr.path <- system.file('extdata', 'Sparkling.wtr', package="rLakeAnalyzer")

#Load data for example lake, Sparkilng Lake, Wisconsin.
wtr = load.ts(wtr.path)

\dontrun{
wtr.plot.temp(wtr)
}

}
\author{
Jennifer Brentrup, Taylor Leach, Luke Winslow
}
\seealso{
\code{\link{load.ts}} and \code{\link{wtr.lineseries}}
}
\keyword{hplot}

