% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.functions.R
\name{ts.internal.energy}
\alias{ts.internal.energy}
\title{Calculate physical indices for a timeseries.}
\usage{
ts.internal.energy(wtr, bathy, na.rm = FALSE)
}
\arguments{
\item{wtr}{A data frame of water temperatures (in Celsius). Loaded using
\code{\link{load.ts}}. Must have columns \code{datetime}, \code{wtr_##.#}
where ##.# is depth in meters.}

\item{bathy}{A data frame containing hypsometric data. Loaded using
\code{\link{load.bathy}}}

\item{na.rm}{Boolean indicated if step-by-step removal of NA's should be
tried. If false, a timestep with any NA values will return an NA value. If
true, best effort will be made to calculate indices despite NA values.}
}
\value{
Returns a data frame with the timeseries of calculated derivatives.
All include a \sQuote{datetime} column, but derivative columns differ
between functions.
}
\description{
Functions for simplifying the calculation of physical indices for a
timeseries of observation data.  Can usually be called directly on data
loaded directly using \code{\link{load.ts}} and \code{\link{load.bathy}}.

These are wrapper functions that accept a timeseries of data and call the
core physical metric functions (like \code{\link{schmidt.stability}}) on
each timestep.
}
\seealso{
For loading input data \code{\link{load.ts}},
\code{\link{load.bathy}}.

For the underlying functions operating at each timestep
\code{\link{meta.depths}}, \code{\link{thermo.depth}},
\code{\link{schmidt.stability}}, \code{\link{lake.number}},
\code{\link{internal.energy}}.

Other Timeseries functions for r Lake Analyzer: \code{\link{ts.lake.number}},
  \code{\link{ts.meta.depths}},
  \code{\link{ts.schmidt.stability}},
  \code{\link{ts.thermo.depth}}, \code{\link{ts.uStar}}
}
\keyword{manip}
