% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm-utils.R
\name{cline_calc}
\alias{cline_calc}
\title{Calculate cline of series of segments}
\usage{
cline_calc(z_seg = z_seg, sigma_seg = sigma_seg)
}
\arguments{
\item{z_seg}{depth in metres; should be an increasing vector}

\item{sigma_seg}{parameter measured in the water column profile}
}
\value{
the depth of the cline
}
\description{
Cline depth is defined as the midpoint of the segment connecting inflection
points that has the maximum slope. A cline cannot occur over a depth range
of less than 1m and also cannot be the shallowest segment. Violating both
conditions will thrown warnings though this function handles both
differently. Used mostly with \code{wtr_layer}
}
\references{
Fiedler, Paul C. Comparison of objective descriptions of the
thermocline. Limnology and Oceanography: Methods 8.6 (2010): 313-325.
}
\seealso{
\code{wtr_layer()}
}
\keyword{internal}
