% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ou.R
\name{ou_search}
\alias{ou_search}
\title{Search a Kolada Organizational Unit metadata table}
\usage{
ou_search(ou_df, query, column = NULL)
}
\arguments{
\item{ou_df}{A Kolada Organizational Unit metadata table, as created by e.g.
\code{get_municipality}.}

\item{query}{A search term or a vector of search terms to filter by. Case
insensitive.}

\item{column}{(Optional) A string or character vector with the names of
columns in which to search for \code{query}.}
}
\value{
A Kolada Organizational Unit metadata table
}
\description{
Search a Kolada Organizational Unit metadata table. Only keep rows that
contain the search query. Matches against all columns or columns named
with the \code{column} parameter. For more precise matching, please use
\code{\link[dplyr:filter]{dplyr::filter}}.
}
\examples{
# Search for all OUs matching the search term "skola" (school)
# (skip the parameter "max_results" to actually download all data)
ou_df <- get_ou(max_results = 100)
ou_search(ou_df, "skola")

# Only keep OU entities matching "skola" but not "förskola" (preschool)
# located in Gothenburg municipality and starting with an "A" using
# regex matching
ou_filter <- get_ou(municipality = "1480") \%>\%
  ou_search("^A", column = "title") \%>\%
  ou_search("[^(för)]skola")

}
