% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.FSA.R
\name{fitted.FSA}
\alias{fitted.FSA}
\title{Fitted Values for FSA solutions}
\usage{
\method{fitted}{FSA}(object, ...)
}
\arguments{
\item{object}{FSA object to get fitted values from.}

\item{...}{other parameters passed to fitmodels or fitted function. See help(fitmodels) or help(fitted) for assistance.}
}
\value{
list of fitted values from each FSA model.
}
\description{
Fitted Values for FSA solutions
}
\examples{
#use mtcars package see help(mtcars)
data(mtcars)
colnames(mtcars)
fit<-lmFSA(formula="mpg~hp*wt",data=mtcars,fixvar="hp",
             quad=FALSE,m=2,numrs=10,save_solutions=FALSE,cores=1)
fitted(fit)
}
