\docType{package}
\name{rCMA-package}
\alias{rCMA}
\alias{rCMA-package}
\title{R interface to the Java CMA-ES of Niko Hansen}
\description{
  CMA-ES R-to-Java interface
}
\details{
  \tabular{ll}{ Package: \tab rCMA\cr Type: \tab Package\cr
  Version: \tab 1.0.0\cr Date: \tab 01.03.2013\cr License:
  \tab GPL (>= 2)\cr LazyLoad: \tab yes\cr }

  rCMA is a package to perform CMA-ES optimization, using
  the *Java* implementation by Niko Hansen [Hansen2009].
  \cr CMA-ES [HansOst96, Hansen13] is the Covariance Matrix
  Adapting Evolutionary Strategy for numeric black box
  optimization. \cr The main features of rCMA are:
  \enumerate{ \item Abiltiy to start the Java CMA-ES
  optimization with fitness functions defined in R.  \item
  Constraint handling: Arbitrary constrained can be
  incorporated, see function parameter \code{isFeasible} in
  \code{\link{cmaOptimDP}}.  \item Extensibility: Full
  access to all methods of the Java class
  \code{CMAEvolutionStrategy} through package
  \href{http://cran.r-project.org/web/packages/rJava/index.html}{\code{rJava}}.
  New methods can be added easily.  See
  \code{\link{cmaEvalMeanX}} for further details,
  explanation of JNI types and a full example.  \item Test
  and Debug: The access of Java methods from R allows for
  easy debugging of new R scripts. } The main entry point
  functions are \code{\link{cmaNew}}, \code{\link{cmaInit}}
  and \code{\link{cmaOptimDP}}.

  Note: To install rJava properly on some Unix systmes, it
  might be necessary to issue as root the command \code{R
  CMD javareconf} once, or, as normal user to issue the
  command \code{R CMD javareconf -e} prior to installing
  package rJava or prior to loading library rJava.
}
\author{
  Wolfgang Konen (\email{wolfgang.konen@fh-koeln.de})
}
\references{
  [HansOst96] Hansen, N. and Ostermeier, A.: Adapting
  arbitrary normal mutation distributions in evolution
  strategies: The covariance matrix adaptation.  In
  Proceedings of the 1996 IEEE International Conference on
  Evolutionary Computation, pp. 312-317, 1996.
  \href{https://www.lri.fr/~hansen/CMAES.pdf}{PDF}. \cr
  [Hansen09] \url{https://www.lri.fr/~hansen/javadoc}
  Nikolaus Hansen: Javadoc for CMA-ES Java package
  fr.inria.optimization.cmaes, 2009. \cr [Hansen13]
  \url{https://www.lri.fr/~hansen/cmaesintro.html} Nikolaus
  Hansen: The CMA Evolution Strategy Web Page, 2013.
}
\keyword{CMA}
\keyword{Covariance}
\keyword{Matrix}
\keyword{package}
\keyword{rJava}

