% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AmBalloon.R
\docType{methods}
\name{initialize,AmBalloon-method}
\alias{amBalloon}
\alias{initialize,AmBalloon-method}
\alias{setAdjustBorderColor}
\alias{setAdjustBorderColor,AmBalloon,logical-method}
\alias{setColor}
\alias{setColor,AmBalloon,character-method}
\alias{setCornerRadius}
\alias{setCornerRadius,AmBalloon,numeric-method}
\alias{setFillColor}
\alias{setFillColor,AmBalloon,character-method}
\title{Initialize an AmBalloon}
\usage{
\S4method{initialize}{AmBalloon}(.Object, adjustBorderColor, color,
  cornerRadius, fillColor, ...)

amBalloon(adjustBorderColor, color, cornerRadius, fillColor, ...)

setAdjustBorderColor(.Object, adjustBorderColor)

\S4method{setAdjustBorderColor}{AmBalloon,logical}(.Object, adjustBorderColor)

setColor(.Object, color)

\S4method{setColor}{AmBalloon,character}(.Object, color)

setCornerRadius(.Object, cornerRadius)

\S4method{setCornerRadius}{AmBalloon,numeric}(.Object, cornerRadius)

setFillColor(.Object, fillColor)

\S4method{setFillColor}{AmBalloon,character}(.Object, fillColor)
}
\arguments{
\item{.Object}{\linkS4class{AmBalloon}.}

\item{adjustBorderColor}{\code{logical}.
If this is set to TRUE, border color instead of background color will be changed when
user rolls-over the slice, graph, etc.}

\item{color}{\code{character}.
Color of text in the balloon.}

\item{cornerRadius}{\code{numeric}.
Balloon corner radius.}

\item{fillColor}{\code{character}.
Balloon background color. Usually balloon background color is set by the chart.
Only if "adjustBorderColor" is "true" this color will be used.}

\item{...}{Other properties of AmBalloon.
See \url{http://docs.amcharts.com/3/javascriptcharts/AmBalloon}.}
}
\value{
An object of class \code{\linkS4class{AmBalloon}}.
}
\description{
Initialize an AmBalloon

Setter for adjustBorderColor

Setter for color

Setter for corner radius

Setter for fillColor
}
\section{Functions}{
\itemize{
\item \code{amBalloon}: 
}}
\examples{
new("AmBalloon", cornerRadius = 10)
amBalloon(adjustBorderColor = TRUE, color = "#000000")
setAdjustBorderColor(.Object = amBalloon(), adjustBorderColor = TRUE)
setColor(.Object = amBalloon(), color = "#000000")
setCornerRadius(.Object = amBalloon(), cornerRadius = 5)
setFillColor(.Object = amBalloon(), fillColor = "#FFFFFF")
}

