% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sharedGenerics.R
\name{setDataProvider}
\alias{addGuide}
\alias{addValueAxis}
\alias{setDataProvider}
\alias{setGraph}
\alias{setText}
\alias{setTitle}
\alias{setType}
\alias{setValueAxis}
\title{Shared generics methods}
\usage{
setDataProvider(.Object, dataProvider, keepNA = TRUE)

setTitle(.Object, title)

setType(.Object, type)

setGraph(.Object, graph = NULL, ...)

addGuide(.Object, guide = NULL, ...)

setText(.Object, text)

setValueAxis(.Object, valueAxis = NULL, ...)

addValueAxis(.Object, valueAxis = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{AmObject}.}

\item{dataProvider}{\code{data.frame}.}

\item{keepNA}{\code{logical}, default \code{TRUE}.
Indicates if \code{NULL} values have to be kept or ignored.}

\item{title}{\code{character}.}

\item{type}{\code{character}.}

\item{graph}{\linkS4class{AmGraph}.}

\item{...}{Other properties.}

\item{guide}{\linkS4class{Guide}.}

\item{text}{\code{character}.}

\item{valueAxis}{\linkS4class{ValueAxis}.}
}
\description{
Shared generics methods
}
\details{
setDataProvider(..) is hared by AmGraph and DataSet

setTitle(...) is Shared by AmGraph and ValueAxis

setType(...) is shared by AmGraph and AmChart

setGraph(...) is shared by AmChart and ChartScrollbar

addGuide(...) is shared by AxisBase and AmChart

setText(...) is shared by Title and Label

setValueAxis(...) is shared by AmChart(type = "gantt"), TrendLine and Guide

addValueAxis(...) is shared by TrendLine and Guide
}

