/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.analyst.scenario.Scenario;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.api.util.TransitModes;
import com.conveyal.r5.transit.TransportNetwork;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;
import org.ipea.r5r.Utils.Utils;

public abstract class R5Process {
    protected final ForkJoinPool r5rThreadPool;
    protected final TransportNetwork transportNetwork;
    protected final RoutingProperties routingProperties;
    protected String[] fromIds;
    protected double[] fromLats;
    protected double[] fromLons;
    protected int nOrigins;
    protected EnumSet<LegMode> directModes;
    protected EnumSet<TransitModes> transitModes;
    protected EnumSet<LegMode> accessModes;
    protected EnumSet<LegMode> egressModes;
    protected String departureDate;
    protected String departureTime;
    protected int maxWalkTime;
    protected int maxBikeTime;
    protected int maxTripDuration;

    public R5Process(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        this.r5rThreadPool = threadPool;
        this.transportNetwork = transportNetwork;
        this.routingProperties = routingProperties;
    }

    public void setOrigins(String[] fromIds, double[] fromLats, double[] fromLons) {
        this.fromIds = fromIds;
        this.fromLats = fromLats;
        this.fromLons = fromLons;
        this.nOrigins = fromIds.length;
    }

    public void setModes(String directModes, String accessModes, String transitModes, String egressModes) {
        this.directModes = Utils.setLegModes(directModes);
        this.accessModes = Utils.setLegModes(accessModes);
        this.egressModes = Utils.setLegModes(egressModes);
        this.transitModes = Utils.setTransitModes(transitModes);
    }

    public void setDepartureDateTime(String departureDate, String departureTime) {
        this.departureDate = departureDate;
        this.departureTime = departureTime;
    }

    public void setTripDuration(int maxWalkTime, int maxBikeTime, int maxTripDuration) {
        this.maxWalkTime = maxWalkTime;
        this.maxBikeTime = maxBikeTime;
        this.maxTripDuration = maxTripDuration;
    }

    public RDataFrame run() throws ExecutionException, InterruptedException {
        int[] requestIndices = IntStream.range(0, this.nOrigins).toArray();
        AtomicInteger totalProcessed = new AtomicInteger(1);
        List processResults = (List)((ForkJoinTask)this.r5rThreadPool.submit(() -> Arrays.stream(requestIndices).parallel().mapToObj(index -> this.tryRunProcess(totalProcessed, index)).filter(Objects::nonNull).collect(Collectors.toList()))).get();
        System.out.print(".. DONE!\n");
        if (!Utils.verbose & Utils.progress) {
            System.out.print(".. DONE!\n");
        }
        return this.mergeResults(processResults);
    }

    private RDataFrame tryRunProcess(AtomicInteger totalProcessed, int index) {
        RDataFrame results = null;
        try {
            long start = System.currentTimeMillis();
            results = this.runProcess(index);
            long duration = Math.max(System.currentTimeMillis() - start, 0L);
            if (results != null & Utils.benchmark) {
                results.addLongColumn("execution_time", duration);
            }
            if (Utils.saveOutputToCsv & results != null) {
                String filename = Utils.outputCsvFolder + "/from_" + this.fromIds[index] + ".csv";
                results.saveToCsv(filename);
                results.clear();
            }
            if (!Utils.verbose & Utils.progress) {
                System.out.print("\r" + totalProcessed.getAndIncrement() + " out of " + this.nOrigins + " origins processed.");
            }
        }
        catch (FileNotFoundException | ParseException e) {
            e.printStackTrace();
        }
        return Utils.saveOutputToCsv ? null : results;
    }

    protected abstract RDataFrame runProcess(int var1) throws ParseException;

    private RDataFrame mergeResults(List<RDataFrame> processResults) {
        if (!Utils.verbose & Utils.progress) {
            System.out.print("Consolidating results...");
        }
        int nRows = processResults.stream().mapToInt(RDataFrame::nRow).sum();
        RDataFrame mergedDataFrame = this.buildDataFrameStructure("", nRows);
        if (Utils.benchmark) {
            mergedDataFrame.addLongColumn("execution_time", 0L);
        }
        ((Stream)mergedDataFrame.getDataFrame().keySet().stream().parallel()).forEach(key -> {
            ArrayList<Object> destinationArray = mergedDataFrame.getDataFrame().get(key);
            processResults.forEach(dataFrame -> {
                ArrayList<Object> originArray = dataFrame.getDataFrame().get(key);
                destinationArray.addAll(originArray);
                originArray.clear();
            });
        });
        mergedDataFrame.updateRowCount();
        if (!Utils.verbose & Utils.progress) {
            System.out.print(" DONE!\n");
        }
        return mergedDataFrame;
    }

    protected abstract RDataFrame buildDataFrameStructure(String var1, int var2);

    protected RegionalTask buildRequest(int index) throws ParseException {
        int secondsFromMidnight;
        RegionalTask request = new RegionalTask();
        request.scenario = new Scenario();
        request.scenarioId = request.scenario.id = "id";
        request.zoneId = this.transportNetwork.getTimeZone();
        request.fromLat = this.fromLats[index];
        request.fromLon = this.fromLons[index];
        request.walkSpeed = (float)this.routingProperties.walkSpeed;
        request.bikeSpeed = (float)this.routingProperties.bikeSpeed;
        request.streetTime = this.maxTripDuration;
        request.maxWalkTime = this.maxWalkTime;
        request.maxBikeTime = this.maxBikeTime;
        request.maxCarTime = this.maxTripDuration;
        request.maxTripDurationMinutes = this.maxTripDuration;
        request.makeTauiSite = false;
        request.recordTimes = true;
        request.recordAccessibility = false;
        request.maxRides = this.routingProperties.maxRides;
        request.bikeTrafficStress = this.routingProperties.maxLevelTrafficStress;
        request.directModes = this.directModes;
        request.accessModes = this.accessModes;
        request.egressModes = this.egressModes;
        request.transitModes = this.transitModes;
        request.date = LocalDate.parse(this.departureDate);
        request.fromTime = secondsFromMidnight = Utils.getSecondsFromMidnight(this.departureTime);
        request.toTime = secondsFromMidnight + this.routingProperties.timeWindowSize * 60;
        request.monteCarloDraws = this.routingProperties.numberOfMonteCarloDraws;
        request.percentiles = this.routingProperties.percentiles;
        return request;
    }
}

