% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SSplotMnwt}
\alias{SSplotMnwt}
\title{Plot mean weight data and fits.}
\usage{
SSplotMnwt(replist, subplots = 1:2, ymax = NULL, plot = TRUE,
  print = FALSE, fleets = "all", fleetnames = "default",
  datplot = FALSE, labels = c("Year", "discard", "retained catch",
  "whole catch", "Mean individual body weight (kg)", "Mean weight in", "for"),
  col1 = "blue", col2 = "black", pwidth = 7, pheight = 7,
  punits = "in", res = 300, ptsize = 12, cex.main = 1,
  plotdir = "default", verbose = TRUE)
}
\arguments{
\item{replist}{list created by \code{SS_output}}

\item{ymax}{Optional input to override default ymax value.}

\item{subplots}{Vector of which plots to make (1 = data only, 2 = with fit).
If \code{plotdat = FALSE} then subplot 1 is not created, regardless of
choice of \code{subplots}.}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{fleets}{optional vector to subset fleets for which plots will be made}

\item{fleetnames}{optional replacement for fleenames used in data file}

\item{datplot}{Make data-only plot of discards? This can override the choice
of \code{subplots}.}

\item{labels}{vector of labels for plots (titles and axis labels)}

\item{col1}{first color to use in plot (for expected values)}

\item{col2}{second color to use in plot (for observations and intervals)}

\item{pwidth}{width of plot written to PNG file}

\item{pheight}{height of plot written to PNG file}

\item{punits}{units for PNG file}

\item{res}{resolution for PNG file}

\item{ptsize}{ptsize for PNG file}

\item{cex.main}{character expansion for plot titles}

\item{verbose}{report progress to R GUI?}
}
\description{
Plot mean weight data and fits from Stock Synthesis output. Intervals are
based on T-distributions as specified in model.
}
\author{
Ian Taylor, Ian Stewart
}
\seealso{
\code{\link{SS_plots}}, \code{\link{SS_output}}
}
\keyword{hplot}

