% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSpoints.R
\name{points3js}
\alias{points3js}
\title{Add points to a data3js object}
\usage{
points3js(
  data3js,
  x,
  y,
  z,
  size = 1,
  col = "black",
  fill = col,
  shape = "sphere",
  highlight,
  geometry = TRUE,
  label = NULL,
  toggle = NULL,
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{x}{point x coords}

\item{y}{point y coords}

\item{z}{point z coords}

\item{size}{point sizes}

\item{col}{point colors}

\item{fill}{point fill color}

\item{shape}{point shapes, see the examples below for a list of different types.}

\item{highlight}{highlight characteristics (see \code{highlight3js()})}

\item{geometry}{logical, should the point be rendered as a physical geometry}

\item{label}{optional vector of interactive labels to apply to the points (see \code{highlight3js()})}

\item{toggle}{optional vector of interactive toggles associate to each point (see \code{highlight3js()})}

\item{...}{further parameters to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
This is the base function for adding points to a plot. Alongside other parameters
you will need to decide whether you want the points plotted as physical geometries
(geometry = TRUE) or webgl points rendered with a shader (geometry = FALSE). Points
rendered as geometries use \code{geopoint3js()} and will respect lighting and intersect
properly, also more point types are supported but come at a larger computational
cost of rendering. webgl points use \code{glpoints3js()} and are rendered orders of
magnitude faster but have less flexible appearances and ignore lighting.
}
\examples{
geo_shapes <- c(
  "circle", "square", "triangle",
  "circle open", "square open", "triangle open",
  "circle filled", "square filled", "triangle filled",
  "sphere", "cube", "tetrahedron",
  "cube open",
  "cube filled"
)

gl_shapes <- c(
  "circle", "square", "triangle",
  "circle open", "square open", "triangle open",
  "circle filled", "square filled", "triangle filled",
  "sphere"
)

# Setup base plot
p <- plot3js(
  xlim = c(0, length(geo_shapes) + 1),
  ylim = c(-4, 4),
  zlim = c(-4, 4),
  label_axes = FALSE
)

# Plot the different point geometries
p <- points3js(
  data3js = p,
  x = seq_along(geo_shapes),
  y = rep(0, length(geo_shapes)),
  z = rep(0, length(geo_shapes)),
  size = 2,
  shape = geo_shapes,
  col = rainbow(length(geo_shapes)),
  fill = "grey70"
)

r3js(p, rotation = c(0, 0, 0), zoom = 2)

# Setup base plot
p <- plot3js(
  xlim = c(0, length(gl_shapes) + 1),
  ylim = c(-4, 4),
  zlim = c(-4, 4),
  label_axes = FALSE
)

# Plot the different gl points
p <- points3js(
  data3js = p,
  x = seq_along(gl_shapes),
  y = rep(0, length(gl_shapes)),
  z = rep(0, length(gl_shapes)),
  size = 2,
  shape = gl_shapes,
  col = rainbow(length(gl_shapes)),
  fill = "grey50",
  geometry = FALSE
)

r3js(p, rotation = c(0, 0, 0), zoom = 2)

# Plot a 10,000 points using the much more efficient gl.point representation

# Setup base plot
p <- plot3js(
  xlim = c(-4, 4),
  ylim = c(-4, 4),
  zlim = c(-4, 4),
  label_axes = FALSE
)

p <- points3js(
  data3js = p,
  x = rnorm(10000, 0),
  y = rnorm(10000, 0),
  z = rnorm(10000, 0),
  size = 0.6,
  col = rainbow(10000),
  shape = "sphere",
  geometry = FALSE
)

r3js(p, rotation = c(0, 0, 0), zoom = 2)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
