% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_plot.R
\name{box_plot}
\alias{box_plot}
\title{Box Plots}
\usage{
box_plot(
  data,
  variables,
  group = NULL,
  cut.names = NULL,
  style = c("T", "whiskers"),
  coef = c(1.5, 3),
  outlier.shape = c(1, 42),
  version = r2spss_options$get("version"),
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables to be plotted.}

\item{variables}{a character vector specifying separate variables to be
plotted.  If \code{group} is not \code{NULL}, only the first variable is
used and box plots of groups of observations are drawn instead.}

\item{group}{an character string specifying a grouping variable, or
\code{NULL} for no grouping.}

\item{cut.names}{a logical indicating whether to cut long variable names or
group labels to 8 characters.  The default is \code{TRUE} for box plots of
separate variables, but \code{FALSE} for box plots of groups of observations
(which mimics SPSS behavior).}

\item{style}{a character string specifying the box plot style.  Possible
values are \code{"T"} for T-bars (the default) or \code{"whiskers"} for
simple whiskers.}

\item{coef}{a numeric vector of length 2 giving the multipliers of the
interquartile range for determining intermediate and extreme outliers,
respectively.}

\item{outlier.shape}{an integer vector of length 2 giving the plot symbol
for intermediate and extreme outliers, respectively.}

\item{version}{a character string specifying whether the plot should mimic
the look of recent SPSS versions (\code{"modern"}) or older versions (<24;
\code{"legacy"}).}

\item{\dots}{additional arguments to be passed down, in particular
aesthetics (see \code{\link[ggplot2]{geom_boxplot}}).}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}, which produces
a box plot when printed.
}
\description{
Draw box plots of variables in a data frame, including box plots for groups
of observations and box plots for separate variables.  The plots thereby
mimic the look of SPSS graphs.
}
\examples{
## paired sample
# load data
data("Exams")

# plot grades on regular and resit exams
box_plot(Exams, c("Regular", "Resit"))


## independent samples

# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# plot log market values of Dutch and Foreign players
box_plot(Eredivisie, "logMarketValue", group = "Foreign")

}
\author{
Andreas Alfons
}
\keyword{hplot}
