/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.model.ToStringHelper;

public class BinaryFeature
extends Feature
implements HasDerivedName {
    private Object value = null;

    public BinaryFeature(PMMLEncoder encoder, Field<?> field, Object value) {
        this(encoder, field.getName(), field.getDataType(), value);
    }

    public BinaryFeature(PMMLEncoder encoder, Feature feature, Object value) {
        this(encoder, feature.getName(), feature.getDataType(), value);
    }

    public BinaryFeature(PMMLEncoder encoder, FieldName name, DataType dataType, Object value) {
        super(encoder, name, dataType);
        this.setValue(value);
    }

    @Override
    public FieldName getDerivedName() {
        return FieldName.create((String)(this.getName().getValue() + "=" + this.getValue()));
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        return this.toContinuousFeature(this.getDerivedName(), DataType.DOUBLE, () -> new NormDiscrete(this.getName(), this.getValue()));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BinaryFeature) {
            BinaryFeature that = (BinaryFeature)object;
            return super.equals(object) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("value", this.getValue());
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object value) {
        this.value = Objects.requireNonNull(value);
    }
}

