/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMML;
import org.dmg.pmml.UnivariateStats;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.visitors.AttributeCleaner;
import org.jpmml.converter.visitors.ModelCleanerBattery;

public class ModelEncoder
extends PMMLEncoder {
    private List<Model> transformers = new ArrayList<Model>();
    private Map<FieldName, List<Decorator>> decorators = new LinkedHashMap<FieldName, List<Decorator>>();
    private Map<FieldName, UnivariateStats> univariateStats = new LinkedHashMap<FieldName, UnivariateStats>();

    public PMML encodePMML(Model model) {
        PMML pmml = this.encodePMML();
        List<Model> transformers = this.getTransformers();
        if (transformers.size() > 0) {
            ArrayList<Model> models = new ArrayList<Model>(transformers);
            if (model != null) {
                models.add(model);
            }
            model = MiningModelUtil.createModelChain(models);
        }
        if (model != null) {
            pmml.addModels(new Model[]{model});
            ModelCleanerBattery modelCleanerBattery = new ModelCleanerBattery();
            if (modelCleanerBattery.size() > 0) {
                modelCleanerBattery.applyTo((Visitable)pmml);
            }
            MiningSchema miningSchema = model.getMiningSchema();
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                UnivariateStats univariateStats;
                FieldName name = miningField.getName();
                DataField dataField = this.getDataField(name);
                if (dataField == null) {
                    throw new IllegalArgumentException("Field " + name.getValue() + " is not referentiable");
                }
                List<Decorator> decorators = this.getDecorators(name);
                if (decorators != null) {
                    for (Decorator decorator : decorators) {
                        decorator.decorate(miningField);
                    }
                }
                if ((univariateStats = this.getUnivariateStats(name)) == null) continue;
                ModelStats modelStats = ModelUtil.ensureModelStats(model);
                modelStats.addUnivariateStats(new UnivariateStats[]{univariateStats});
            }
        }
        AttributeCleaner pmmlCleaner = new AttributeCleaner();
        pmmlCleaner.applyTo((Visitable)pmml);
        return pmml;
    }

    public List<Model> getTransformers() {
        return this.transformers;
    }

    public void addTransformer(Model transformer) {
        this.transformers.add(transformer);
    }

    public List<Decorator> getDecorators(FieldName name) {
        return this.decorators.get(name);
    }

    public void addDecorator(DataField dataField, Decorator decorator) {
        this.addDecorator(dataField.getName(), decorator);
    }

    public void addDecorator(FieldName name, Decorator decorator) {
        List<Decorator> decorators = this.decorators.get(name);
        if (decorators == null) {
            decorators = new ArrayList<Decorator>();
            this.decorators.put(name, decorators);
        }
        decorators.add(decorator);
    }

    public UnivariateStats getUnivariateStats(FieldName name) {
        return this.univariateStats.get(name);
    }

    public void putUnivariateStats(UnivariateStats univariateStats) {
        this.putUnivariateStats(univariateStats.getField(), univariateStats);
    }

    public void putUnivariateStats(FieldName name, UnivariateStats univariateStats) {
        this.univariateStats.put(name, univariateStats);
    }
}

