/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Deque;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.visitors.AbstractVisitor;

public abstract class AbstractTreeModelTransformer
extends AbstractVisitor {
    public void pushParent(PMMLObject object) {
        super.pushParent(object);
        if (object instanceof Node) {
            this.enterNode((Node)object);
        } else if (object instanceof TreeModel) {
            this.enterTreeModel((TreeModel)object);
        }
    }

    public PMMLObject popParent() {
        PMMLObject object = super.popParent();
        if (object instanceof Node) {
            this.exitNode((Node)object);
        } else if (object instanceof TreeModel) {
            this.exitTreeModel((TreeModel)object);
        }
        return object;
    }

    public void enterNode(Node node) {
    }

    public void exitNode(Node node) {
    }

    public void enterTreeModel(TreeModel treeModel) {
    }

    public void exitTreeModel(TreeModel treeModel) {
    }

    protected Node getParentNode() {
        Deque parents = this.getParents();
        PMMLObject parent = (PMMLObject)parents.peekFirst();
        if (parent instanceof Node) {
            return (Node)parent;
        }
        if (parent instanceof TreeModel) {
            return null;
        }
        throw new IllegalStateException();
    }

    public Node getAncestorNode(java.util.function.Predicate<Node> predicate) {
        Deque parents = this.getParents();
        for (PMMLObject parent : parents) {
            if (parent instanceof Node) {
                Node node = (Node)parent;
                if (!predicate.test(node)) continue;
                return node;
            }
            if (parent instanceof TreeModel) {
                return null;
            }
            throw new IllegalStateException();
        }
        return null;
    }

    protected TreeModel getParentTreeModel() {
        Deque parents = this.getParents();
        for (PMMLObject parent : parents) {
            if (parent instanceof Node) continue;
            if (parent instanceof TreeModel) {
                return (TreeModel)parent;
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    protected static List<Node> swapChildren(Node node) {
        List children = node.getNodes();
        if (children.size() != 2) {
            throw new IllegalArgumentException();
        }
        Node firstChild = (Node)children.remove(0);
        children.add(1, firstChild);
        return children;
    }

    protected static void initScore(Node parentNode, Node node) {
        Object score = node.getScore();
        if (parentNode.hasScore()) {
            throw new IllegalArgumentException();
        }
        parentNode.setScore(score);
    }

    protected static void initScoreDistribution(Node parentNode, Node node) {
        Object score = node.getScore();
        Double recordCount = node.getRecordCount();
        if (parentNode.hasScore()) {
            throw new IllegalArgumentException();
        }
        parentNode.setScore(score);
        Double parentRecordCount = parentNode.getRecordCount();
        if (parentRecordCount != null) {
            throw new IllegalArgumentException();
        }
        parentNode.setRecordCount(recordCount);
        if (parentNode.hasScoreDistributions()) {
            throw new IllegalArgumentException();
        }
        if (node.hasScoreDistributions()) {
            List scoreDistributions = node.getScoreDistributions();
            List parentScoreDistributions = parentNode.getScoreDistributions();
            if (parentScoreDistributions.size() != 0) {
                throw new IllegalArgumentException();
            }
            parentScoreDistributions.addAll(scoreDistributions);
        }
    }

    protected static void replaceChildWithGrandchildren(Node parentNode, Node node) {
        List parentChildren = parentNode.getNodes();
        int index = parentChildren.indexOf(node);
        if (index < 0 || index != parentChildren.size() - 1) {
            throw new IllegalArgumentException();
        }
        parentChildren.remove(index);
        if (node.hasNodes()) {
            List children = node.getNodes();
            parentChildren.addAll(index, children);
        }
    }

    protected static boolean equalsNode(Object defaultChild, Node node) {
        if (defaultChild instanceof Node) {
            return defaultChild.equals(node);
        }
        return defaultChild.equals(node.getId());
    }

    protected static boolean hasFieldReference(Predicate predicate, FieldName name) {
        if (predicate instanceof HasFieldReference) {
            HasFieldReference hasFieldReference = (HasFieldReference)predicate;
            return hasFieldReference.getField().equals((Object)name);
        }
        return false;
    }

    protected static boolean hasValue(Predicate predicate, String value) {
        if (predicate instanceof HasValue) {
            HasValue hasValue = (HasValue)predicate;
            return hasValue.getValue().equals(value);
        }
        return false;
    }

    protected static boolean hasOperator(Predicate predicate, SimplePredicate.Operator operator) {
        if (predicate instanceof SimplePredicate) {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            return simplePredicate.getOperator().equals((Object)operator);
        }
        return false;
    }

    protected static boolean hasBooleanOperator(Predicate predicate, SimpleSetPredicate.BooleanOperator booleanOperator) {
        if (predicate instanceof SimpleSetPredicate) {
            SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)predicate;
            return simpleSetPredicate.getBooleanOperator().equals((Object)booleanOperator);
        }
        return false;
    }

    protected static void checkFieldReference(Predicate left, Predicate right) {
        AbstractTreeModelTransformer.checkFieldReference((HasFieldReference)left, (HasFieldReference)right);
    }

    protected static void checkFieldReference(HasFieldReference<?> left, HasFieldReference<?> right) {
        if (!left.getField().equals((Object)right.getField())) {
            throw new IllegalArgumentException();
        }
    }

    protected static void checkValue(Predicate left, Predicate right) {
        AbstractTreeModelTransformer.checkValue((HasValue)left, (HasValue)right);
    }

    protected static void checkValue(HasValue<?> left, HasValue<?> right) {
        if (!left.getValue().equals(right.getValue())) {
            throw new IllegalArgumentException();
        }
    }
}

