% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aided_chatgpt.R
\name{rows.rep}
\alias{rows.rep}
\title{Replicate Rows in a Data Frame}
\usage{
rows.rep(data, n)
}
\arguments{
\item{data}{A data frame whose rows are to be replicated.}

\item{n}{An integer specifying the number of times each row should be replicated.}
}
\value{
A data frame with each row replicated `n` times. If `n` is less than or equal to 0, an empty data frame is returned.
}
\description{
This function replicates each row in a data frame a specified number of times.
}
\examples{
# Example with a simple data frame
df <- data.frame(A = c(1, 2), B = c("x", "y"))
rows.rep(df, 3)

# Example with no replication (n = 0)
rows.rep(df, 0)

}
