% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{track_func}
\alias{track_func}
\title{A function that tracks usage of other functions}
\usage{
track_func(output.dest = "output_tracking.csv")
}
\arguments{
\item{output.dest}{destination of csv file to store outputs}
}
\value{
the numeric count of a function usage
}
\description{
Up count the number of times a particular function is called
}
\examples{
\dontrun{
# Track usage of type2 and type1 functions
store.usage.file <- tempfile()
type5 <- function(x) type2(x)
type4 <- function(x) type3(x)
type3 <- function(x) type1(x)
type1 <- function(x) {
  mean(x)
  sd(x)
  track_func(store.usage.file)
}
type2 <- function(x) {
  type1(x)
  track_func(store.usage.file)
}

# add usage counts to store.usage.file
type1(number(10))
type2(number(10))
type3(number(10))
type4(number(10))
type5(number(10))
}
}
