% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{n_compare}
\alias{n_compare}
\title{Test for Equal Frequency of Values (chi-square test of goodness of fit)}
\usage{
n_compare(x, simulate.p.value = FALSE, B = 2000)
}
\arguments{
\item{x}{atomic vector. Probably makes sense to contain relatively few unique
values.}

\item{simulate.p.value}{logial vector of length 1 specifying whether the
p-value should be based on a Monte Carlo simulation rather than the classic
formula. See \code{\link[stats]{chisq.test}} for details.}

\item{B}{integer vector of length 1 specifying how much Monte Carlo
simulations run. Only used if \code{simulate.p.value} = TRUE. See
\code{\link[stats]{chisq.test}} for details.}
}
\value{
list of numeric vectors containing statistical information about the
  frequency comparison: 1) nhst = chi-square test of goodness of fit stat info
  in a numeric vector, 2) count = numeric vector of length 3 with table of counts,
  3) percent = numeric vector of length 3 with table of overall percentages

1) nhst = chi-square test of goodness of fit stat info in a numeric vector

\describe{
   \item{diff_avg}{average difference in subsample sizes (i.e., |ni - nj|)}
   \item{se}{NA (to remind the user there is no standard error for the test)}
   \item{X2}{chi-square value}
   \item{df}{degrees of freedom (# of unique values = 1)}
   \item{p}{two-sided p-value}
}

2) count = numeric vector of length 3 with table of counts with an additional
element for the total. The names are 1. "n_`lvl[k]`", 2. "n_`lvl[j]`", 3.
"n_`lvl[i]`", ...,  X = "total"

3) percent = numeric vector of length 3 with table of overall percentages with an additional
element for the total. The names are 1. "n_`lvl[k]`", 2. "n_`lvl[j]`", 3.
"n_`lvl[i]`", ...,  X = "total"
}
\description{
\code{n_compare} tests whether all the values for a variable have equal
frequency with a chi-square test of goodness of fit. \code{n_compare} does
not currently allow for user-specified unequal frequencies of values; this is
possible with \code{\link[stats]{chisq.test}}. The function also calculates
the counts and overall percentages for the value frequencies.
\code{prop_test} is simply a wrapper for \code{\link[stats]{chisq.test}} plus
some extra calculations.
}
\examples{

n_compare(mtcars$"cyl")
n_compare(mtcars$"gear")
n_compare(mtcars$"cyl", simulate.p.value = TRUE)

# compare to chisq.test()
n_compare(mtcars$"cyl")
chisq.test(table(mtcars$"cyl"))

}
\seealso{
\code{\link[stats]{chisq.test}} the workhorse for \code{n_compare},
   \code{\link{props_test}} for multiple dummy variables,
   \code{\link{prop_diff}} for chi-square test of independence,
}
