% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-LagKernelWeight.R
\docType{methods}
\name{plot-LagKernelWeight}
\alias{plot,LagKernelWeight,missing-method}
\alias{plot-LagKernelWeight}
\title{Plot the values of the \code{\link{LagKernelWeight}}.}
\usage{
\S4method{plot}{LagKernelWeight,missing}(x, y, ylab = expression(W[n](k)),
  xlab = expression(k), main = x@descr, ...)
}
\arguments{
\item{x}{The \code{\link{LagKernelWeight}} to plot.}

\item{y}{missing arg from the generic; will be ignored.}

\item{ylab}{label for the y-axis; optional}

\item{xlab}{label for the x-axis; optional}

\item{main}{titel (on top) of the plot; optional}

\item{...}{optional parameters used for plotting}
}
\value{
Plots the \code{\link{LagKernelWeight}}.
}
\description{
Creates a plot visualizing the weights \eqn{W_n(k}
[cf. \code{\link{LagKernelWeight-class}}] that are used to estimate the
quantile spectral density.
}
\details{
In the plot the values at the points \eqn{k/bw}{k/bw} with
\eqn{k \in \{-K,\dots,K\}}{(-K:k:K)} are shown.
}
\examples{
plot(lagKernelWeight(WParzen, bw=10, K = 20),
       ylab=expression(W[n](x)),
       xlab=expression(x),
       main="Weights to the Parzen Window")
}

