% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_quantities}
\alias{parse_quantities}
\alias{parse_units}
\alias{parse_errors}
\title{Parse Units and Errors}
\usage{
parse_quantities(x, decimal_mark)

parse_units(x, decimal_mark)

parse_errors(x, decimal_mark)
}
\arguments{
\item{x}{a character vector to parse.}

\item{decimal_mark}{the dot (\code{.}) if not provided.}
}
\value{
A \code{quantities}, \code{units} or \code{errors} object respectively.
}
\description{
Functions to parse character vectors into quantities.
}
\details{
Each \code{parse_*()} function returns an object of the corresponding
type, no matter what it is found. This means that, for \code{parse_units}, if
errors are found, they are dropped with a warning. Similarly for
\code{parse_errors}, if units are found, they are dropped with a warning.
On the other hand, \code{parse_quantities} always returns a valid
\code{quantities} object, even if no errors or units are found (then, zero
error and dimensionless units are applied).
}
\examples{
parse_quantities("(1.6021766208 +/- .0000000098) e-19 C")
parse_quantities("1.6021766208(98) e-19 C")
parse_units("1.6021766208 e-19 C")
parse_errors("1.6021766208(98) e-19")

# quantities are converted to the first unit
parse_quantities(c("12.34(2) m/s", "36.5(1) km/h"))

# or kept as a list of mixed units
parse_quantities(c("1.02(5) g", "2.51(0.01) V", "(3.23 +/- 0.12) m"))

}
