% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens.R
\name{tokens}
\alias{tokens}
\title{Tokenize a set of texts}
\usage{
tokens(x, what = c("word", "sentence", "character", "fastestword",
  "fasterword"), remove_numbers = FALSE, remove_punct = FALSE,
  remove_symbols = FALSE, remove_separators = TRUE,
  remove_twitter = FALSE, remove_hyphens = FALSE, remove_url = FALSE,
  ngrams = 1L, skip = 0L, concatenator = "_",
  verbose = quanteda_options("verbose"), include_docvars = TRUE, ...)
}
\arguments{
\item{x}{a character, \link{corpus}, or \link{tokens} object to be tokenized}

\item{what}{the unit for splitting the text, available alternatives are: 
\describe{ \item{\code{"word"}}{(recommended default) smartest, but 
slowest, word tokenization method; see 
\link[stringi]{stringi-search-boundaries} for details.} 
\item{\code{"fasterword"}}{dumber, but faster, word tokenization method, 
uses \code{{\link[stringi]{stri_split_charclass}(x, "\\\\p{WHITE_SPACE}")}}} 
\item{\code{"fastestword"}}{dumbest, but fastest, word tokenization method,
calls \code{\link[stringi]{stri_split_fixed}(x, " ")}} 
\item{\code{"character"}}{tokenization into individual characters} 
\item{\code{"sentence"}}{sentence segmenter, smart enough to handle some 
exceptions in English such as "Prof. Plum killed Mrs. Peacock." (but far 
from perfect).} }}

\item{remove_numbers}{remove tokens that consist only of numbers, but not 
words that start with digits, e.g. \code{2day}}

\item{remove_punct}{if \code{TRUE}, remove all characters in the Unicode 
"Punctuation" [P] class}

\item{remove_symbols}{if \code{TRUE}, remove all characters in the Unicode 
"Symbol" [S] class}

\item{remove_separators}{remove Separators and separator characters (spaces 
and variations of spaces, plus tab, newlines, and anything else in the 
Unicode "separator" category) when \code{remove_punct=FALSE}.  Only 
applicable for \code{what = "character"} (when you probably want it to be 
\code{FALSE}) and for \code{what = "word"} (when you probably want it to be
\code{TRUE}).  Note that if \code{what = "word"} and you set 
\code{remove_punct = TRUE}, then \code{remove_separators} has no effect.  Use
carefully.}

\item{remove_twitter}{remove Twitter characters \code{@} and \code{#}; set to
\code{TRUE} if you wish to eliminate these.  Note that this will always be set 
to \code{FALSE} if \code{remove_punct = FALSE}.}

\item{remove_hyphens}{if \code{TRUE}, split words that are connected by 
hyphenation and hyphenation-like characters in between words, e.g. 
\code{"self-storage"} becomes \code{c("self", "storage")}.  Default is 
\code{FALSE} to preserve such words as is, with the hyphens.  Only applies 
if \code{what = "word"}.}

\item{remove_url}{if \code{TRUE}, find and eliminate URLs beginning with 
http(s) -- see section "Dealing with URLs".}

\item{ngrams}{integer vector of the \emph{n} for \emph{n}-grams, defaulting 
to \code{1} (unigrams). For bigrams, for instance, use \code{2}; for 
bigrams and unigrams, use \code{1:2}.  You can even include irregular 
sequences such as \code{2:3} for bigrams and trigrams only.  See 
\code{\link{tokens_ngrams}}.}

\item{skip}{integer vector specifying the skips for skip-grams, default is 0 
for only immediately neighbouring words. Only applies if \code{ngrams} is 
different from the default of 1.  See \code{\link{tokens_skipgrams}}.}

\item{concatenator}{character to use in concatenating \emph{n}-grams, default
is "\code{_}", which is recommended since this is included in the regular 
expression and Unicode definitions of "word" characters}

\item{verbose}{if \code{TRUE}, print timing messages to the console; off by 
default}

\item{include_docvars}{if \code{TRUE}, pass docvars and metadoc fields through to 
the tokens object.  Only applies when tokenizing \link{corpus} objects.}

\item{...}{additional arguments not used}
}
\value{
\pkg{quanteda} \code{tokens} class object, by default a serialized list 
  of integers corresponding to a vector of types.
}
\description{
Tokenize the texts from a character vector or from a corpus.
}
\details{
The tokenizer is designed to be fast and flexible as well as to 
  handle Unicode correctly. Most of the time, users will construct \link{dfm}
  objects from texts or a corpus, without calling \code{tokens()} as an 
  intermediate step.  Since \code{tokens()} is most likely to be used by more
  technical users, we have set its options to default to minimal 
  intervention. This means that punctuation is tokenized as well, and that 
  nothing is removed by default from the text being tokenized except 
  inter-word spacing and equivalent characters.
  
  Note that a \code{tokens} constructor also works on \link{tokens} objects, 
  which allows setting additional options that will modify the original object.
  It is not possible, however, to change a setting to "un-remove" something 
  that was removed from the input \link{tokens} object, however.  For instance,
  \code{tokens(tokens("Ha!", remove_punct = TRUE), remove_punct = FALSE)} will 
  not restore the \code{"!"} token.  No warning is currently issued about this,
  so the user should use \code{tokens.tokens()} with caution.
}
\section{Dealing with URLs}{
 URLs are tricky to tokenize, because they contain
  a number of symbols and punctuation characters.  If you wish to remove 
  these, as most people do, and your text contains URLs, then you should set 
  \code{what = "fasterword"} and \code{remove_url = TRUE}.  If you wish to 
  keep the URLs, but do not want them mangled, then your options are more 
  limited, since removing punctuation and symbols will also remove them from 
  URLs.  We are working on improving this behaviour.
  
  See the examples below.
}

\examples{
txt <- c(doc1 = "This is a sample: of tokens.",
         doc2 = "Another sentence, to demonstrate how tokens works.")
tokens(txt)
# removing punctuation marks and lowecasing texts
tokens(char_tolower(txt), remove_punct = TRUE)
# keeping versus removing hyphens
tokens("quanteda data objects are auto-loading.", remove_punct = TRUE)
tokens("quanteda data objects are auto-loading.", remove_punct = TRUE, remove_hyphens = TRUE)
# keeping versus removing symbols
tokens("<tags> and other + symbols.", remove_symbols = FALSE)
tokens("<tags> and other + symbols.", remove_symbols = TRUE)
tokens("<tags> and other + symbols.", remove_symbols = FALSE, what = "fasterword")
tokens("<tags> and other + symbols.", remove_symbols = TRUE, what = "fasterword")

## examples with URLs - hardly perfect!
txt <- "Repo https://githib.com/kbenoit/quanteda, and www.stackoverflow.com."
tokens(txt, remove_url = TRUE, remove_punct = TRUE)
tokens(txt, remove_url = FALSE, remove_punct = TRUE)
tokens(txt, remove_url = FALSE, remove_punct = TRUE, what = "fasterword")
tokens(txt, remove_url = FALSE, remove_punct = FALSE, what = "fasterword")


## MORE COMPARISONS
txt <- "#textanalysis is MY <3 4U @myhandle gr8 #stuff :-)"
tokens(txt, remove_punct = TRUE)
tokens(txt, remove_punct = TRUE, remove_twitter = TRUE)
#tokens("great website http://textasdata.com", remove_url = FALSE)
#tokens("great website http://textasdata.com", remove_url = TRUE)

txt <- c(text1="This is $10 in 999 different ways,\\n up and down; left and right!", 
         text2="@kenbenoit working: on #quanteda 2day\\t4ever, http://textasdata.com?page=123.")
tokens(txt, verbose = TRUE)
tokens(txt, remove_numbers = TRUE, remove_punct = TRUE)
tokens(txt, remove_numbers = FALSE, remove_punct = TRUE)
tokens(txt, remove_numbers = TRUE, remove_punct = FALSE)
tokens(txt, remove_numbers = FALSE, remove_punct = FALSE)
tokens(txt, remove_numbers = FALSE, remove_punct = FALSE, remove_separators = FALSE)
tokens(txt, remove_numbers = TRUE, remove_punct = TRUE, remove_url = TRUE)

# character level
tokens("Great website: http://textasdata.com?page=123.", what = "character")
tokens("Great website: http://textasdata.com?page=123.", what = "character", 
         remove_separators = FALSE)

# sentence level         
tokens(c("Kurt Vongeut said; only assholes use semi-colons.", 
           "Today is Thursday in Canberra:  It is yesterday in London.", 
           "Today is Thursday in Canberra:  \\nIt is yesterday in London.",
           "To be?  Or\\nnot to be?"), 
          what = "sentence")
tokens(data_corpus_inaugural[c(2,40)], what = "sentence")

# removing features (stopwords) from tokenized texts
txt <- char_tolower(c(mytext1 = "This is a short test sentence.",
                      mytext2 = "Short.",
                      mytext3 = "Short, shorter, and shortest."))
tokens(txt, remove_punct = TRUE)
tokens_remove(tokens(txt, remove_punct = TRUE), stopwords("english"))

# ngram tokenization
tokens(txt, remove_punct = TRUE, ngrams = 2)
tokens(txt, remove_punct = TRUE, ngrams = 2, skip = 1, concatenator = " ")
tokens(txt, remove_punct = TRUE, ngrams = 1:2)
# removing features from ngram tokens
tokens_remove(tokens(txt, remove_punct = TRUE, ngrams = 1:2), stopwords("english"))
}
\seealso{
\code{\link{tokens_ngrams}}, \code{\link{tokens_skipgrams}}, \code{\link{as.list.tokens}}
}
\keyword{tokens}
