% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_description.R
\name{fetch_description}
\alias{fetch_description}
\title{Download complete survey description using the Qualtrics v3 "Get Survey"
API endpoint.}
\usage{
fetch_description(surveyID, elements = NULL, legacy = FALSE, ...)
}
\arguments{
\item{surveyID}{A string. Unique ID for the survey you want to download.
Returned as "id" by the \link{all_surveys} function.}

\item{elements}{A character vector. Lists elements of survey definition to be
maintained.  Possible elements are "metadata", "surveyoptions", "flow",
"blocks", "questions", "responsesets", and/or "scoring" (case-insensitive).
If \code{legacy = TRUE}, then possible elements are "metadata", "questions",
"responsecounts", "blocks", "flow", "embedded_data", and/or "comments".}

\item{legacy}{Logical.  If TRUE, will use older Get Survey API endpoint
via a call to legacy function \link{metadata}.}

\item{...}{Additional options, only used when \code{legacy = TRUE}. User may pass
an argument called \code{questions}, a vector containing the names of questions
for which you want to return metadata.}
}
\value{
A list containing survey description metadata. The contents of the
returned list depend on \code{elements}.
}
\description{
Download complete survey description using the Qualtrics v3 "Get Survey"
API endpoint.
}
\details{
If the request to the Qualtrics API made by this function fails, the request
will be retried. If you see these failures on a 500 error (such as a 504
error) be patient while the request is retried; it will typically succeed
on retrying. If you see other types of errors, retrying is unlikely to help.
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
qualtrics_api_credentials(
  api_key = "<YOUR-API-KEY>",
  base_url = "<YOUR-BASE-URL>"
)

# Retrieve a list of surveys
surveys <- all_surveys()

# Get description for a survey
descrip <- fetch_description(surveyID = surveys$id[6])

# Get metadata with specific elements
descrip_specific <- fetch_description(
  surveyID = id,
  elements = c("questions", "flow")
)

}
}
