% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_raster.R
\name{as_raster}
\alias{as_raster}
\alias{as_raster,Quadtree-method}
\title{Create a raster from a \code{Quadtree}}
\usage{
\S4method{as_raster}{Quadtree}(x, rast = NULL)
}
\arguments{
\item{x}{a \code{\link{Quadtree}}}

\item{rast}{a \code{\link[raster:RasterLayer-class]{RasterLayer}}; optional;
this will be used as a template - the output raster will have the same
extent and dimensions as this raster. If \code{NULL} (the default), a
raster is automatically created, where the quadtree extent is used as the
raster extent, and the size of smallest cell in the quadtree is used as
the resolution of the raster.}
}
\value{
a \code{\link[raster:RasterLayer-class]{RasterLayer}}
}
\description{
Creates a \code{\link[raster:RasterLayer-class]{RasterLayer}}
  from a \code{\link{Quadtree}}.
}
\details{
Note that the value of a raster cell is determined by the value of the
quadtree cell located at the centroid of the raster cell - thus, if a raster
cell overlaps several quadtree cells, whichever quadtree cell the centroid of
the raster cell falls in will determine the raster cell's value. If no value
is provided for the \code{rast} parameter, the raster's dimensions are
automatically determined from the quadtree in such a way that the cells are
guaranteed to line up with the quadtree cells with no overlap, thus avoiding
the issue.
}
\examples{
library(raster)
library(quadtree)
data(habitat)

# create a quadtree
qt <- quadtree(habitat, split_threshold = .1, split_method = "sd")

rst1 <- as_raster(qt) # use the default raster
rst2 <- as_raster(qt, habitat) # use another raster as a template

old_par <- par(mfrow = c(2, 2))
plot(habitat, main = "original raster")
plot(qt, main = "quadtree")
plot(rst1, main = "raster from quadtree")
plot(rst2, main = "raster from quadtree")
par(old_par)
}
