% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_app.R
\name{visualize_app}
\alias{visualize_app}
\title{Visualize cleaned data}
\usage{
visualize_app(data, xaxis, yaxis)
}
\arguments{
\item{data}{A data frame containing cleaned quadrat data.}

\item{xaxis}{The xaxis variable column names found in \code{data}.}

\item{yaxis}{The yaxis variable column names found in \code{data}.}
}
\value{
A shiny app launched in your browser.
}
\description{
Using an interactive shiny app, visualize and explore cleaned
quadrat data.
}
\examples{
year <- sample(x = seq(from = 2000, to = 2020, by = 1), 1000, replace = TRUE)
site <- sample(x = c("site1", "site2", "site3", "site4", "site5"), 1000, replace = TRUE)
transect <- sample(x = c("transect1", "transect2", "transect3", "transect4"),
    1000, replace = TRUE)
species <- sample(x = c("Acropora", "Gardineroseris", "Psammocora", "Leptastrea"),
    1000, replace = TRUE)
cover <- sample(x = seq(from = 0, to = 1, by = 0.01), 1000, replace = TRUE)

coral <- data.frame(year, site, transect, species, cover)

if (interactive()) {
visualize_app(data = coral, xaxis = colnames(coral[,1:4]), yaxis = "cover")
}

}
