% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_ids.R
\name{replace_ids}
\alias{replace_ids}
\alias{replace_ids.cross2}
\alias{replace_ids.calc_genoprob}
\alias{replace_ids.viterbi}
\alias{replace_ids.sim_geno}
\alias{replace_ids.matrix}
\alias{replace_ids.data.frame}
\title{Replace individual IDs}
\usage{
replace_ids(x, ids)

\method{replace_ids}{cross2}(x, ids)

\method{replace_ids}{calc_genoprob}(x, ids)

\method{replace_ids}{viterbi}(x, ids)

\method{replace_ids}{sim_geno}(x, ids)

\method{replace_ids}{matrix}(x, ids)

\method{replace_ids}{data.frame}(x, ids)
}
\arguments{
\item{x}{Object whose IDs will be replaced}

\item{ids}{Vector of character strings with the new individual IDs, with the names being the original IDs.}
}
\value{
The input \code{x} object, but with individual IDs replaced.
}
\description{
Replace the individual IDs in an object with new ones
}
\section{Methods (by class)}{
\itemize{
\item \code{cross2}: Replace IDs in a \code{"cross2"} object

\item \code{calc_genoprob}: Replace IDs in output from \code{\link[=calc_genoprob]{calc_genoprob()}}

\item \code{viterbi}: Replace IDs in output from \code{\link[=viterbi]{viterbi()}}

\item \code{sim_geno}: Replace IDs in output from \code{\link[=sim_geno]{sim_geno()}}

\item \code{matrix}: Replace IDs in a matrix

\item \code{data.frame}: Replace IDs in a data frame
}}

\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
ids <- as.numeric(ind_ids(iron))

# replace the numeric IDs with IDs like "mouse003"
new_ids <- setNames( sprintf("mouse\%03d", as.numeric(ids)), ids)

iron <- replace_ids(iron, new_ids)
}
