% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showQsprayXYZ}
\alias{showQsprayXYZ}
\title{Print a polynomial}
\usage{
showQsprayXYZ(letters = c("x", "y", "z"), collapse = ".", ...)
}
\arguments{
\item{letters, collapse}{see \code{\link{showMonomialXYZ}}}

\item{...}{arguments passed to \code{\link{showQspray}}, such as 
\code{compact=TRUE}}
}
\value{
A function which prints a \code{qspray} object. It is constructed 
  with \code{\link{showQspray}} and \code{\link{showMonomialXYZ}}.
}
\description{
Prints a polynomial by printing monomials like \code{"x^2.yz"}.
}
\note{
The function returned by this function can be used as the option 
  \code{"showQspray"} in the \code{\link{showQsprayOption<-}} function.
}
\examples{
set.seed(3141)
( qspray <- rQspray() )
showQsprayXYZ(c("X", "Y", "Z"))(qspray)
showQsprayXYZ(c("X", "Y", "Z"))(qlone(1) + qlone(2) + qlone(3) + qlone(4))
# setting a show option:
showQsprayOption(qspray, "showQspray") <- showQsprayXYZ(c("A", "B", "C"))
qspray
# this is equivalent to:
showQsprayOption(qspray, "showMonomial") <- showMonomialXYZ(c("A", "B", "C"))
}
\seealso{
\code{\link{showMonomialXYZ}}, \code{\link{showQspray}}, 
  \code{\link{showQsprayOption<-}}.
}
