% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs_rds_conversion.R
\name{rds_to_qs}
\alias{rds_to_qs}
\title{RDS to qs2 format}
\usage{
rds_to_qs(input_file, output_file, compress_level = 3)
}
\arguments{
\item{input_file}{The \code{RDS} file to convert.}

\item{output_file}{The \code{qs2} file to write.}

\item{compress_level}{The zstd compression level to use when writing the \code{qs2} file. See the \code{qs_save} help file for more details on this parameter.}
}
\value{
No value is returned. The converted file is written to disk.
}
\description{
Converts a file saved in the \code{RDS} format to the \code{qs2} format.
}
\details{
The \code{shuffle} parameters is currently not supported when converting from \code{RDS} to \code{qs2}.
When reading the resulting \code{qs2} file, \code{validate_checksum} must be set to \code{FALSE}.
}
\examples{
qs_tmp <- tempfile(fileext = ".qs2")
rds_tmp <- tempfile(fileext = ".RDS")

x <- runif(1e6)
saveRDS(x, rds_tmp)
rds_to_qs(input_file = rds_tmp, output_file = qs_tmp)
x2 <- qs_read(qs_tmp, validate_checksum = FALSE)
stopifnot(identical(x, x2))
}
