% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{lz4_compress_raw}
\alias{lz4_compress_raw}
\title{lz4 compression}
\usage{
lz4_compress_raw(x, compress_level)
}
\arguments{
\item{x}{The object to serialize.}

\item{compress_level}{The compression level used. A number > 1 (higher is less compressed).}
}
\value{
The compressed data as a raw vector.
}
\description{
Compresses to a raw vector using the lz4 algorithm. Exports the main lz4 compression function.
}
\examples{
x <- 1:1e6
xserialized <- serialize(x, connection=NULL)
xcompressed <- lz4_compress_raw(xserialized, compress_level = 1)
xrecovered <- unserialize(lz4_decompress_raw(xcompressed))
}
