% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.0.R
\name{qcser}
\alias{qcser}
\title{Quantile-Crossing Series (QCSER)}
\usage{
qcser(y, tau, normalize = FALSE)
}
\arguments{
\item{y}{vector or matrix of time series}

\item{tau}{sequence of quantile levels in (0,1)}

\item{normalize}{\code{TRUE} or \code{FALSE} (default): normalize QCSER to have unit variance}
}
\value{
A matrix or array of quantile-crossing series
}
\description{
This function creates the quantile-crossing series (QCSER) for univariate or multivariate time series.
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.qser <- qcser(y,tau)
dim(y.qser)
}
