% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/is.regex.R
\name{is.regex}
\alias{is.regex}
\title{Test Regular Expression Validity}
\usage{
is.regex(pattern)
}
\arguments{
\item{pattern}{A regular expression to be tested.}
}
\value{
Returns a logical (\code{TRUE} is a valid regular expression).
}
\description{
Acts as a logical test of a regular expression's validity.  \code{is.regex}
uses \code{\link[base]{gsub}} and tests for errors to determine a regular
expression's validity.  The regular expression must conform to R's regular
expression rules (see \code{?regex} for details about how R handles regular
expressions).
}
\examples{
is.regex("I|***")
is.regex("I|i")

sapply(regex_usa, is.regex)
sapply(regex_supplement, is.regex) ## `version` is not a valid regex
}
\seealso{
\code{\link[base]{gsub}}
}
\keyword{regex,}
\keyword{valid}

