% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.R
\name{prop}
\alias{prop}
\title{Convert Raw Numeric Matrix or Data Frame to Proportions}
\usage{
prop(mat, digits = 2, percent = FALSE, by.column = TRUE,
  round = FALSE)
}
\arguments{
\item{mat}{A numeric matrix or dataframe.}

\item{digits}{Integer; number of decimal places to round.}

\item{percent}{logical.  If \code{TRUE} output given as percent.  If 
\code{FALSE} the output is proportion.}

\item{by.column}{logical.  If \code{TRUE} applies to the column.  If 
\code{FALSE} applies by row.}

\item{round}{logical.  If \code{TRUE} rounds the returned values (controlled 
by digits).}
}
\value{
Returns a matrix with proportionally scaled values.
}
\description{
Convert a raw matrix or dataframe to proportions/percents.  Divides each 
element of a column by the column sum.
}
\examples{
\dontrun{
y <- wfdf(DATA$state, DATA$person, stopwords = c("your", "yours"), 
    margins = TRUE)
prop(wfm(y), 4)[1:10, ]        #as a proportion
prop(wfm(y), 4, TRUE)[1:10, ]  #as a percentage
heatmap(prop(wfm(y), 4))
wdstraj <- word_stats(rajSPLIT$dialogue, rajSPLIT$person)
prop(wdstraj$gts[, -1], 5)[1:15, 1:6]
}
}
\keyword{percent,}
\keyword{percentage}
\keyword{proportion,}
