% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Animate.character.R
\name{Animate.character}
\alias{Animate.character}
\title{Animate Character}
\usage{
\method{Animate}{character}(x, wc.time = TRUE, time.constant = 2,
  width = 65, coord = c(0, 0.5), just = c(0, 0.5), size = 5,
  color = "black", border.color = NA, ...)
}
\arguments{
\item{x}{A \code{\link[base]{character}} object.}

\item{wc.time}{logical.  If \code{TRUE} weights duration of frame by word 
count.}

\item{time.constant}{A constant to divide the maximum word count by.  Time
is calculated by `round(exp(WORD COUNT/(max(WORD COUNT)/time.constant)))`.  
Therefore a larger constant will make the difference between the large and 
small word counts greater.}

\item{width}{The width to break text at if \code{type = "text"}.}

\item{coord}{The x/y coordinate to plot the text..}

\item{just}{The \code{hjust} and \code{vjust} values to use for the text.}

\item{size}{The size to print the text.  Can be a vector of length 1 or equal 
to the length of \code{x}.}

\item{color}{The color to print the text.  Can be a vector of length 1 or equal 
to the length of \code{x}.}

\item{border.color}{The \code{panel.border} color (see\code{\link[ggplot2]{theme}}).}

\item{\ldots}{Other arguments passed to \code{\link[ggplot2]{annotate}}.}
}
\description{
\code{Animate.character} - Animate a \code{\link[base]{character}} object.  
Typically this function is useful in conjunction with other \code{Animate}
objects to create complex animations with accompanying text.
}
\details{
character Method for Animate
}
\examples{
\dontrun{
Animate(DATA[["state"]])
Animate(DATA[["state"]], color="red")
Animate(DATA[["state"]], color=RColorBrewer::brewer.pal(11, "Set3"), size=10)
cls <- DATA[["person"]] \%l\% data.frame(levels(DATA[["person"]]), 
    RColorBrewer::brewer.pal(5, "Set3"))
Animate(DATA[["state"]], color=cls, size=10, width=30)
cls2 <- DATA[["sex"]] \%l\% data.frame(c("m", "f"),c("lightblue", "pink"))
Animate(DATA[["state"]], color=cls2, just=c(.5, .5), coord = c(.5, .5))

## Print method
print(Animate(DATA[["state"]], color=cls2, just=c(.5, .5), coord = c(.5, .5)), 
    pause=.25)
Animate(DATA[["state"]], color=sample(colors(), nrow(DATA)), 
    size=sample(4:13, nrow(DATA), TRUE), width=30,  just=c(.5, .5), coord = c(.5, .5))
}
}
\seealso{
\code{\link[ggplot2]{theme}}
}
