% Generated by roxygen2 (4.0.0): do not edit by hand
\name{discourse_map}
\alias{discourse_map}
\title{Discourse Mapping}
\usage{
discourse_map(text.var, grouping.var, edge.constant, sep = "_",
  condense = TRUE, ...)
}
\arguments{
\item{text.var}{The text variable or a  \code{"word_stats"} object (i.e., the
output of a \code{word_stats} function).}

\item{grouping.var}{The grouping variables.  Also takes a single grouping
variable or a list of 1 or more grouping variables.}

\item{edge.constant}{A constant to multiple the edges by.  Defaults (if
\code{missing}) to 2.5 times the number of social actors.}

\item{\ldots}{ignored}

\item{condense}{logical.  If \code{TRUE} \code{sentCombine} is used to
condense text by grouping variable.}

\item{sep}{The separator character to use between grouping variables.}
}
\value{
Returns a list:
\item{raw}{The dataframe with to and from columns (the edges) + word counts}
\item{edge_word_count}{A dataframe of edges and word counts + proportional
word count}
\item{vertex_word_count}{A dataframe of vertices and word counts +
proportional word count}
\item{plot}{An \pkg{igraph} object}
}
\description{
View the flow of discourse from social actors.
}
\details{
For an example of the video generated from the \code{Animate}
output of \code{discourse_map} see:
\url{https://www.youtube.com/watch?v=7LcqFZODXNo&feature=youtu.be}.  An HTML
output can be viewed:
\url{http://trinker.github.io/qdap_examples/animation_dialogue}.
}
\examples{
\dontrun{
discourse_map(DATA$state, list(DATA$person, DATA$sex))
x <- with(mraja1, discourse_map(dialogue, person))
x
lview(x)
library(igraph)
plot(visual(x), edge.curved=FALSE)

## Quickly add/remove a title
Title(x) <- "Act 1"
x
Title(x) <- NULL
x

## Augmenting the plot
library(qdapTools)
mygraph <- visual(x)

plot(mygraph, edge.curved=TRUE)

V(mygraph)$sex <- V(mygraph)$name \%l\% raj.demographics[, 1:2]
V(mygraph)$color <- ifelse(V(mygraph)$sex=="f", "pink", "lightblue")

plot(mygraph, edge.curved=TRUE)

V(mygraph)$family <- V(mygraph)$name \%l+\% raj.demographics[, c(1, 3)]
cols <- qcv(blue, red, brown, darkgreen, grey10)
V(mygraph)$label.color <- lookup(V(mygraph)$family,
    unique(V(mygraph)$family), cols)

plot(mygraph, edge.curved=TRUE)

## Repeated Measures (BASIC EXAMPLE)
##------------------------------

## First merge data and map to discourse per act
## to separate networks

dat <- key_merge(raj, raj.demographics)
list_dat <- split(dat, dat$act)
plot_dat <- lapply(list_dat, function(x) with(x, discourse_map(dialogue, person)))

opar <- par()$mar
par(mfrow=c(3, 2), mar=c(0, 0, 3, 0))

lapply(seq_along(plot_dat), function(i){
    plot(plot_dat[[i]])
    mtext(paste("Act", names(plot_dat)[i]), side=3)
})


## Repeated Measures (EXTENDED EXAMPLE)
##------------------------------
fam_key <- data.frame(fam=unique(raj.demographics$fam.aff),
    cols=qcv(blue, grey10, red, orange),
    stringsAsFactors = FALSE)

par(mfrow=c(3, 2), mar=c(0, 1, 3, 1))
lapply(seq_along(plot_dat), function(i){

    THE_PLOT <- visual(plot_dat[[i]])

    V(THE_PLOT)$sex <- V(THE_PLOT)$name \%l\% raj.demographics[, 1:2]
    V(THE_PLOT)$color <- ifelse(V(THE_PLOT)$sex=="f", "pink", "lightblue")
    V(THE_PLOT)$family <- V(THE_PLOT)$name \%lc+\% raj.demographics[, c(1, 3)]
    V(THE_PLOT)$label.color <- lookup(V(THE_PLOT)$family, fam_key)

    plot(THE_PLOT, edge.curved=TRUE)
    mtext(paste("Act", names(plot_dat)[i]), side=3)
})
frame()
bords <- rep("black", 7)
bords[3] <- "white"
legend(.29, .95, c("Female", "Male", NA, as.character(fam_key[, 1])),
    fill=c("pink", "lightblue", NA, fam_key[, 2]), border=bords, cex=1.5)

## Reset graphics margins
par(mar=opar)

## ANIMATION
#===========
test <- discourse_map(DATA$state, list(DATA$person))

## Very quick, hard to see
Animate(test)

pdf("test.pdf")
    par(mar=c(0, 0, 1, 0))
    Animate(test, title="Test Plot")
dev.off()

## Animate it
##-----------
library(animation)
library(igraph)

loc <- folder(animation_dialogue)
ans <- Animate(test)

## Set up the plotting function
oopt <- animation::ani.options(interval = 0.1)

FUN <- function() {
    lapply(seq_along(ans), function(i) {
        par(mar=c(0, 0, 1, 0))
        set.seed(10)
        plot.igraph(ans[[i]], edge.curved=TRUE, layout=layout.circle)
        mtext("Discourse Map", side=3)
        animation::ani.pause()
    })
}

## Detect OS
type <- if(.Platform$OS.type == "windows") shell else system
saveGIF(FUN(), interval = 0.1, outdir = loc, cmd.fun = type)

saveVideo(FUN(), video.name = "discourse_map.avi", interval = 0.1, outdir = loc)

saveLatex(FUN(), autoplay = TRUE, loop = FALSE, latex.filename = "tester.tex",
    caption = "animated dialogue", outdir = loc, ani.type = "pdf",
    ani.dev = "pdf", ani.width = 5, ani.height = 5.5, interval = 0.1)

saveHTML(FUN(), autoplay = FALSE, loop = TRUE, verbose = FALSE,
    outdir = file.path(loc, "new"), single.opts =
    "'controls': ['first', 'previous', 'play', 'next', 'last', 'loop', 'speed'], 'delayMin': 0")


## More Elaborate Layout
test2 <- with(mraja1, discourse_map(dialogue, person))

loc2 <- folder(animation_dialogue2)
ans2 <- Animate(test2)
## Set up the plotting function
oopt <- animation::ani.options(interval = 0.1)

FUN3 <- function() {
    lapply(seq_along(ans2), function(i) {
        par(mar=c(0, 0, 1, 0))
        set.seed(10)
        plot.igraph(ans2[[i]], edge.curved=TRUE, layout=layout.auto)
        mtext("Discourse Map\\nRomeo and Juliet: Act 1", side=3)
        animation::ani.pause()
    })
}

saveHTML(FUN3(), autoplay = FALSE, loop = FALSE, verbose = FALSE,
    outdir = file.path(loc2, "new"), single.opts =
    "'controls': ['first', 'play', 'loop', 'speed'], 'delayMin': 0")

saveVideo(FUN3(), video.name = "discourse_map.avi", interval = 0.2,
    outdir = loc2)
}
}

