% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_apps.R
\name{get_app}
\alias{get_app}
\title{Get an app}
\usage{
get_app(
  subdomain,
  auth,
  app_id,
  agent = NULL,
  include_sec = T,
  include_vars = T
)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{app_id}{Character vector with one element. Unique identifier of an app.
Found in the URL of the app's homepage after /db/}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}

\item{include_sec}{Logical. Includes security properties if true.}

\item{include_vars}{Logical. Includes app variables if true.}
}
\value{
A tibble.
}
\description{
Get metadata for an app.
}
\examples{
\dontrun{
   get_app(subdomain = "abc",
              auth = keyring::key_get("qb_example"),
              app_id = "bsf5hphe5")
}
}
