% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qstats.r
\name{qstats}
\alias{qstats}
\title{Summary statistics for a quantitative variable}
\usage{
qstats(data, x, ..., stats = c("n", "mean", "sd"), na.rm = TRUE, digits = 2)
}
\arguments{
\item{data}{data frame}

\item{x}{numeric variable in data (unquoted)}

\item{...}{list of grouping variables}

\item{stats}{statistics to calculate (any function that produces a
numeric value), Default: \code{c("n", "mean", "sd")}}

\item{na.rm}{if \code{TRUE}, delete cases with missing values on x and or grouping
variables, Default: \code{TRUE}}

\item{digits}{number of decimal digits to print, Default: 2}
}
\value{
a data frame, where columns are grouping variables (optional) and
statistics
}
\description{
This function provides descriptive statistics for a quantitative
variable alone or separately by groups. Any function that returns a single
numeric value can bue used.
}
\examples{
# If no keyword arguments are provided, default values are used
qstats(mtcars, mpg, am, gear)

# You can supply as many (or no) grouping variables as needed
qstats(mtcars, mpg)

qstats(mtcars, mpg, am, cyl)

# You can specify your own functions (e.g., median,
# median absolute deviation, minimum, maximum))
qstats(mtcars, mpg, am, gear,
       stats = c("median", "mad", "min", "max"))
}
