% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetAssignment.R
\name{GetAssignment}
\alias{GetAssignment}
\alias{GetAssignments}
\alias{assignment}
\alias{assignments}
\alias{ListAssignmentsForHIT}
\title{Get Assignment(s)}
\usage{
GetAssignment(
  assignment = NULL,
  hit = NULL,
  hit.type = NULL,
  annotation = NULL,
  status = NULL,
  results = as.integer(100),
  pagetoken = NULL,
  get.answers = FALSE,
  persist.on.error = FALSE,
  verbose = getOption("pyMTurkR.verbose", TRUE)
)
}
\arguments{
\item{assignment}{An optional character string specifying the AssignmentId
of an assignment to return. Must specify \code{assignment} xor \code{hit}
xor \code{hit.type} xor \code{annotation}.}

\item{hit}{An optional character string specifying the HITId whose
assignments are to be returned, or a vector of character strings specifying
multiple HITIds all of whose assignments are to be returned. Must specify
\code{assignment} xor \code{hit} xor \code{hit.type} xor \code{annotation}.}

\item{hit.type}{An optional character string specifying the HITTypeId (or a
vector of HITTypeIds) of one or more HITs whose assignments are to be
returned. Must specify \code{assignment} xor \code{hit} xor \code{hit.type}
xor \code{annotation}.}

\item{annotation}{An optional character string specifying the value of the
\code{RequesterAnnotation} field for a batch of HITs. This can be used to
retrieve all assignments for all HITs from a \dQuote{batch} created in the
online Requester User Interface (RUI). To use a batch ID, the batch must be
written in a character string of the form \dQuote{BatchId:78382;}, where
\dQuote{73832} is the batch ID shown in the RUI. Must specify
\code{assignment} xor \code{hit} xor \code{hit.type} xor \code{annotation}.}

\item{status}{An optional vector of character strings (containing one of more of
\dQuote{Approved},\dQuote{Rejected},\dQuote{Submitted}), specifying whether
only a subset of assignments should be returned. If \code{NULL}, all
assignments are returned (the default). Only applies when \code{hit} or
\code{hit.type} are specified; ignored otherwise.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{get.answers}{An optional logical indicating whether to also get the
answers. If TRUE, the returned object is a list with Assignments and Answers.}

\item{persist.on.error}{A boolean specifying whether to persist on an error.
Errors can sometimes happen when the server times-out, in cases where large
numbers of Assignments are being retrieved.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame representing an assignment or multiple assignments for
one or more HITs (or a HITType).
}
\description{
Get an assignment or multiple assignments for one or more HITs (or a
HITType) as a data frame.
}
\details{
This function returns the requested assignments. The function must specify
an AssignmentId xor a HITId xor a HITTypeId. If an AssignmentId is
specified, only that assignment is returned. If a HIT or HITType is
specified, default behavior is to return all assignments through a series of
sequential (but invisible) API calls meaning that returning large numbers of
assignments (or assignments for a large number of HITs in a single request)
may be time consuming.

\code{GetAssignments()}, \code{assignment()}, \code{assignments()},
and \code{ListAssignmentsForHIT()} are aliases.
}
\examples{

\dontrun{
# get an assignment
GetAssignment(assignments = "26XXH0JPPSI23H54YVG7BKLEXAMPLE")
# get all assignments for a HIT
GetAssignment(hit = "2MQB727M0IGF304GJ16S1F4VE3AYDQ")
# get all assignments for a HITType
GetAssignment(hit.type = "2FFNCWYB49F9BBJWA4SJUNST5OFSOW")
# get all assignments for an online batch from the RUI
GetAssignment(annotation="BatchId:78382;")
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html}{API
Reference: GetAssignment}

\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html}{API Reference: ListAssignmentsForHIT}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Assignments}
