% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DisposeQualificationType.R
\name{DisposeQualificationType}
\alias{DisposeQualificationType}
\alias{DeleteQualificationType}
\alias{disposequal}
\alias{deletequal}
\title{Dispose QualificationType}
\usage{
DisposeQualificationType(qual, verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{qual}{A character string containing a QualificationTypeId.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the QualificationTypeId and whether the
request to dispose was valid.
}
\description{
Dispose of a QualificationType. This deletes the QualificationType,
Qualification scores for all workers, and all records thereof.
}
\details{
A function to dispose of a QualificationType that is no longer needed. It will
dispose of the Qualification type and any HIT types that are associated with it.
It does not not revoke Qualifications already assigned to Workers. Any pending
requests for this Qualification are automatically rejected.

\code{DisposeQualificationType()}, \code{disposequal()}, and \code{deletequal()}
are aliases.
}
\examples{

\dontrun{
qual1 <-
CreateQualificationType(name = "Worked for me before",
    description = "This qualification is for people who have worked for me before",
    status = "Active",
    keywords = "Worked for me before")
DisposeQualificationType(qual1$QualificationTypeId)
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html}{API Reference}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
